/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import org.codehaus.plexus.util.FileUtils;
import org.commonjava.indy.action.IndyLifecycleException;
import org.commonjava.indy.action.MigrationAction;
import org.commonjava.indy.folo.ctl.FoloAdminController;
import org.commonjava.indy.folo.data.FoloFiler;
import org.commonjava.indy.folo.data.FoloSealedCache;
import org.commonjava.indy.folo.model.TrackedContent;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.subsys.infinispan.CacheHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordsMigrationAction
implements MigrationAction {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private FoloFiler foloFiler;
    @Inject
    private FoloAdminController controller;
    @FoloSealedCache
    @Inject
    private CacheHandle<TrackingKey, TrackedContent> sealedRecordCache;

    public boolean migrate() throws IndyLifecycleException {
        File file = this.foloFiler.getSealedZipFile().getDetachedFile();
        if (file.exists()) {
            this.logger.info("Migrate Folo sealed records, file: {}", (Object)file);
            File dataFile = this.foloFiler.getSealedDataFile().getDetachedFile();
            if (dataFile.exists()) {
                File dataFileBak = new File(dataFile.getAbsolutePath() + ".bak." + new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss.SSS").format(new Date()));
                try {
                    this.logger.info("Back up dataFile to {}", (Object)dataFileBak);
                    FileUtils.rename((File)dataFile, (File)dataFileBak);
                }
                catch (IOException e) {
                    throw new IndyLifecycleException("Backup {} to {} failed", new Object[]{dataFile, dataFileBak, e});
                }
            }
            try (FileInputStream stream = new FileInputStream(file);){
                this.controller.importRecordZip(stream);
            }
            catch (Exception e) {
                throw new IndyLifecycleException("Import sealed records failed", (Throwable)e, new Object[0]);
            }
            File toFile = new File(file.getAbsolutePath() + ".loaded");
            try {
                FileUtils.rename((File)file, (File)toFile);
                this.logger.info("Rename {} to {}", (Object)file, (Object)toFile);
            }
            catch (IOException e) {
                throw new IndyLifecycleException("Rename {} to {} failed", new Object[]{file, toFile, e});
            }
        }
        this.logger.info("Folo migration zip file not exist, file: {}", (Object)file.getAbsolutePath());
        return true;
    }

    public String getId() {
        return "folo-sealed-records";
    }

    public int getMigrationPriority() {
        return 90;
    }
}

