/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.data;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.indy.IndyWorkflowException;
import org.commonjava.indy.folo.change.FoloBackupListener;
import org.commonjava.indy.folo.change.FoloExpirationWarningListener;
import org.commonjava.indy.folo.data.FoloContentException;
import org.commonjava.indy.folo.data.FoloInprogressCache;
import org.commonjava.indy.folo.data.FoloRecord;
import org.commonjava.indy.folo.data.FoloSealedCache;
import org.commonjava.indy.folo.data.FoloStoretoInfinispan;
import org.commonjava.indy.folo.model.StoreEffect;
import org.commonjava.indy.folo.model.TrackedContent;
import org.commonjava.indy.folo.model.TrackedContentEntry;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.subsys.infinispan.CacheHandle;
import org.commonjava.o11yphant.metrics.annotation.Measure;
import org.infinispan.Cache;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@FoloStoretoInfinispan
public class FoloRecordCache
implements FoloRecord {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @FoloInprogressCache
    @Inject
    private CacheHandle<TrackedContentEntry, TrackedContentEntry> inProgressRecordCache;
    @FoloSealedCache
    @Inject
    private CacheHandle<TrackingKey, TrackedContent> sealedRecordCache;
    @Inject
    private FoloBackupListener foloBackupListener;
    @Inject
    private FoloExpirationWarningListener expirationWarningListener;

    protected FoloRecordCache() {
    }

    @PostConstruct
    private void init() {
        this.sealedRecordCache.executeCache(cache -> {
            cache.addListener((Object)this.foloBackupListener);
            return null;
        });
        this.inProgressRecordCache.executeCache(cache -> {
            cache.addListener((Object)this.expirationWarningListener);
            return null;
        });
    }

    public FoloRecordCache(Cache<TrackedContentEntry, TrackedContentEntry> inProgressRecordCache, Cache<TrackingKey, TrackedContent> sealedRecordCache) {
        this.inProgressRecordCache = new CacheHandle("folo-in-progress", inProgressRecordCache);
        this.sealedRecordCache = new CacheHandle("folo-sealed", sealedRecordCache);
    }

    @Override
    @Measure
    public synchronized boolean recordArtifact(TrackedContentEntry entry) throws FoloContentException, IndyWorkflowException {
        if (this.sealedRecordCache.containsKey((Object)entry.getTrackingKey())) {
            throw new FoloContentException("Tracking record: {} is already sealed!", entry.getTrackingKey());
        }
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.debug("Adding tracking entry: {}", (Object)entry);
        return (Boolean)this.inProgressRecordCache.executeCache(cache -> {
            TrackedContentEntry existing = (TrackedContentEntry)cache.get((Object)entry);
            if (existing != null) {
                existing.merge(entry);
                cache.put((Object)existing, (Object)existing);
            } else {
                cache.put((Object)entry, (Object)entry);
            }
            return true;
        });
    }

    @Override
    @Measure
    public synchronized void delete(TrackingKey key) {
        this.sealedRecordCache.remove((Object)key);
        this.inProgressByTrackingKey(key, (qb, ch) -> {
            qb.build().list().forEach(item -> {
                TrackedContentEntry cfr_ignored_0 = (TrackedContentEntry)ch.execute(cache -> (TrackedContentEntry)cache.remove(item));
            });
            return false;
        });
    }

    @Override
    public synchronized void replaceTrackingRecord(TrackedContent record) {
        this.sealedRecordCache.put((Object)record.getKey(), (Object)record);
    }

    @Override
    public synchronized boolean hasRecord(TrackingKey key) {
        return this.hasSealedRecord(key) || this.hasInProgressRecord(key);
    }

    public synchronized boolean hasSealedRecord(TrackingKey key) {
        return this.sealedRecordCache.containsKey((Object)key);
    }

    @Measure
    public synchronized boolean hasInProgressRecord(TrackingKey key) {
        return !this.sealedRecordCache.containsKey((Object)key) && this.inProgressByTrackingKey(key, (qb, cacheHandle) -> qb.build().getResultSize() > 0) != false;
    }

    @Override
    public synchronized TrackedContent get(TrackingKey key) {
        return (TrackedContent)this.sealedRecordCache.get((Object)key);
    }

    @Override
    @Measure
    public TrackedContent seal(TrackingKey trackingKey) {
        TrackedContent record = (TrackedContent)this.sealedRecordCache.get((Object)trackingKey);
        Logger logger = LoggerFactory.getLogger(this.getClass());
        if (record != null) {
            logger.debug("Tracking record: {} already sealed! Returning sealed record.", (Object)trackingKey);
            return record;
        }
        logger.debug("Listing unsealed tracking record entries for: {}...", (Object)trackingKey);
        return this.inProgressByTrackingKey(trackingKey, (qb, cacheHandle) -> {
            Query query = qb.build();
            List results = query.list();
            TrackedContent created = null;
            if (results != null) {
                logger.debug("Adding {} entries to record: {}", (Object)results.size(), (Object)trackingKey);
                TreeSet uploads = new TreeSet();
                TreeSet downloads = new TreeSet();
                results.forEach(result -> {
                    if (StoreEffect.DOWNLOAD == result.getEffect()) {
                        downloads.add(result);
                    } else if (StoreEffect.UPLOAD == result.getEffect()) {
                        uploads.add(result);
                    }
                    logger.trace("Removing in-progress entry: {}", result);
                    this.inProgressRecordCache.remove(result);
                });
                created = new TrackedContent(trackingKey, uploads, downloads);
            }
            logger.debug("Sealing record for: {}", (Object)trackingKey);
            this.sealedRecordCache.put((Object)trackingKey, created);
            return created;
        });
    }

    @Override
    public Set<TrackingKey> getInProgressTrackingKey() {
        return ((Set)this.inProgressRecordCache.execute(Map::keySet)).stream().map(TrackedContentEntry::getTrackingKey).collect(Collectors.toSet());
    }

    @Override
    public Set<TrackingKey> getSealedTrackingKey() {
        return (Set)this.sealedRecordCache.execute(Map::keySet);
    }

    @Override
    public Set<TrackedContent> getSealed() {
        return ((Set)this.sealedRecordCache.execute(Map::entrySet)).stream().map(et -> (TrackedContent)et.getValue()).collect(Collectors.toSet());
    }

    private <R> R inProgressByTrackingKey(TrackingKey key, BiFunction<QueryBuilder, CacheHandle<TrackedContentEntry, TrackedContentEntry>, R> operation) {
        return (R)this.inProgressRecordCache.executeCache(cache -> {
            QueryFactory queryFactory = Search.getQueryFactory((Cache)cache);
            QueryBuilder qb = ((FilterConditionContext)queryFactory.from(TrackedContentEntry.class).having("trackingKey.id").eq((Object)key.getId())).toBuilder();
            return operation.apply(qb, this.inProgressRecordCache);
        });
    }

    @Override
    public void addSealedRecord(TrackedContent record) {
        this.sealedRecordCache.put((Object)record.getKey(), (Object)record);
    }
}

