/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ctl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.commonjava.cdi.util.weft.DrainingExecutorCompletionService;
import org.commonjava.cdi.util.weft.ExecutorConfig;
import org.commonjava.cdi.util.weft.SingleThreadedExecutorService;
import org.commonjava.cdi.util.weft.WeftExecutorService;
import org.commonjava.cdi.util.weft.WeftManaged;
import org.commonjava.indy.IndyWorkflowException;
import org.commonjava.indy.content.ContentDigester;
import org.commonjava.indy.content.ContentManager;
import org.commonjava.indy.core.ctl.PoolUtils;
import org.commonjava.indy.folo.FoloUtils;
import org.commonjava.indy.folo.conf.FoloConfig;
import org.commonjava.indy.folo.ctl.FoloConstants;
import org.commonjava.indy.folo.data.FoloContentException;
import org.commonjava.indy.folo.data.FoloFiler;
import org.commonjava.indy.folo.data.FoloRecord;
import org.commonjava.indy.folo.data.FoloRecordCache;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.dto.TrackedContentEntryDTO;
import org.commonjava.indy.folo.dto.TrackingIdsDTO;
import org.commonjava.indy.folo.model.StoreEffect;
import org.commonjava.indy.folo.model.TrackedContent;
import org.commonjava.indy.folo.model.TrackedContentEntry;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.model.core.AccessChannel;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.util.ApplicationStatus;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.io.checksum.ContentDigest;
import org.commonjava.maven.galley.io.checksum.TransferMetadata;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.util.UrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FoloAdminController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private FoloConfig config;
    @Inject
    private FoloRecord recordManager;
    @Inject
    private FoloFiler filer;
    @Inject
    private ContentManager contentManager;
    @Inject
    private ContentDigester contentDigester;
    @Inject
    @WeftManaged
    @ExecutorConfig(threads=50, priority=4, named="folo-recalculator", maxLoadFactor=100.0f, loadSensitive=ExecutorConfig.BooleanLiteral.TRUE)
    private WeftExecutorService recalculationExecutor;

    protected FoloAdminController() {
    }

    public FoloAdminController(FoloConfig config, FoloRecordCache recordManager, FoloFiler filer, ContentManager contentManager, ContentDigester contentDigester) {
        this.config = config;
        this.recordManager = recordManager;
        this.filer = filer;
        this.contentManager = contentManager;
        this.contentDigester = contentDigester;
        this.recalculationExecutor = new SingleThreadedExecutorService("folo-recalculator");
    }

    public TrackedContentDTO seal(String id, String baseUrl) {
        TrackingKey tk = new TrackingKey(id);
        return this.constructContentDTO(this.recordManager.seal(tk), baseUrl);
    }

    public void importRecordZip(InputStream stream) throws IndyWorkflowException {
        try {
            int count = FoloUtils.readZipInputStreamAnd(stream, record -> this.recordManager.addSealedRecord((TrackedContent)record));
            this.logger.debug("Import records done, size: {}", (Object)count);
        }
        catch (Exception e) {
            throw new IndyWorkflowException("Failed to import zip file", (Throwable)e, new Object[0]);
        }
    }

    public File renderReportZip() throws IndyWorkflowException {
        Set<TrackedContent> sealed = this.recordManager.getSealed();
        try {
            File file = this.filer.getSealedZipFile().getDetachedFile();
            if (file.exists()) {
                file.delete();
            }
            file.getParentFile().mkdirs();
            FoloUtils.zipTrackedContent(file, sealed);
            return file;
        }
        catch (IOException e) {
            throw new IndyWorkflowException("Failed to create zip file", (Throwable)e, new Object[0]);
        }
    }

    public void doInitialBackUpForSealed() throws IndyWorkflowException {
        Set<TrackedContent> sealed = this.recordManager.getSealed();
        File dir = this.filer.getBackupDir(FoloConstants.TRACKING_TYPE.SEALED.getValue()).getDetachedFile();
        try {
            FoloUtils.backupTrackedContent(dir, sealed);
        }
        catch (IOException e) {
            throw new IndyWorkflowException("Failed to backup sealed", (Throwable)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File renderRepositoryZip(String id) throws IndyWorkflowException {
        TrackingKey tk = new TrackingKey(id);
        File file = this.filer.getRepositoryZipFile(tk).getDetachedFile();
        file.getParentFile().mkdirs();
        this.logger.debug("Retrieving tracking record for: {}", (Object)tk);
        TrackedContent record = this.recordManager.get(tk);
        this.logger.debug("Got: {}", (Object)record);
        if (record == null) {
            throw new IndyWorkflowException(ApplicationStatus.NOT_FOUND.code(), "No tracking record available for: %s. Maybe you forgot to seal it?", new Object[]{tk});
        }
        HashSet<String> seenPaths = new HashSet<String>();
        ArrayList<Transfer> items = new ArrayList<Transfer>();
        this.addTransfers(record.getUploads(), items, id, seenPaths);
        this.addTransfers(record.getDownloads(), items, id, seenPaths);
        this.logger.debug("Retrieved {} files. Creating zip.", (Object)items.size());
        Collections.sort(items, (f, s) -> f.getPath().compareTo(s.getPath()));
        try (ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(file));){
            for (Transfer item : items) {
                if (item == null) continue;
                String path = item.getPath();
                ZipEntry ze = new ZipEntry(path);
                stream.putNextEntry(ze);
                InputStream itemStream = null;
                try {
                    itemStream = item.openInputStream();
                    IOUtils.copy((InputStream)itemStream, (OutputStream)stream);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)itemStream);
                }
            }
        }
        catch (IOException e) {
            throw new IndyWorkflowException("Failed to generate repository zip from tracking record: {}. Reason: {}", (Throwable)e, new Object[]{id, e.getMessage()});
        }
        return file;
    }

    private void addTransfers(Set<TrackedContentEntry> entries, List<Transfer> items, String trackingId, Set<String> seenPaths) throws IndyWorkflowException {
        if (entries != null && !entries.isEmpty()) {
            for (TrackedContentEntry entry : entries) {
                String path = entry.getPath();
                if (path == null || seenPaths.contains(path)) continue;
                StoreKey sk = entry.getStoreKey();
                Transfer transfer = this.contentManager.getTransfer(sk, path, TransferOperation.DOWNLOAD);
                if (transfer == null) {
                    Logger logger = LoggerFactory.getLogger(this.getClass());
                    logger.warn("While creating Folo repo zip for: {}, cannot find: {} in: {}", new Object[]{trackingId, path, sk});
                    continue;
                }
                seenPaths.add(path);
                items.add(transfer);
            }
        }
    }

    public TrackedContentDTO renderReport(String id, String apiBaseUrl) throws IndyWorkflowException {
        TrackingKey tk = new TrackingKey(id);
        this.logger.debug("Retrieving tracking record for: {}", (Object)tk);
        TrackedContentDTO record = this.constructContentDTO(this.recordManager.get(tk), apiBaseUrl);
        this.logger.debug("Got: {}", (Object)record);
        return record;
    }

    public TrackedContentDTO getRecord(String id, String baseUrl) throws IndyWorkflowException {
        TrackingKey tk = new TrackingKey(id);
        return this.constructContentDTO(this.recordManager.get(tk), baseUrl);
    }

    public void clearRecord(String id) throws FoloContentException {
        TrackingKey tk = new TrackingKey(id);
        this.recordManager.delete(tk);
    }

    private TrackedContentDTO constructContentDTO(TrackedContent content, String baseUrl) {
        if (content == null) {
            return null;
        }
        TreeSet<TrackedContentEntryDTO> uploads = new TreeSet<TrackedContentEntryDTO>();
        for (TrackedContentEntry entry : content.getUploads()) {
            uploads.add(this.constructContentEntryDTO(entry, baseUrl));
        }
        TreeSet<TrackedContentEntryDTO> downloads = new TreeSet<TrackedContentEntryDTO>();
        for (TrackedContentEntry entry : content.getDownloads()) {
            downloads.add(this.constructContentEntryDTO(entry, baseUrl));
        }
        return new TrackedContentDTO(content.getKey(), uploads, downloads);
    }

    private TrackedContentEntryDTO constructContentEntryDTO(TrackedContentEntry entry, String apiBaseUrl) {
        if (entry == null) {
            return null;
        }
        TrackedContentEntryDTO entryDTO = new TrackedContentEntryDTO(entry.getStoreKey(), entry.getAccessChannel(), entry.getPath());
        try {
            entryDTO.setLocalUrl(UrlUtils.buildUrl((String)apiBaseUrl, (String[])new String[]{"content", entryDTO.getStoreKey().getPackageType(), entryDTO.getStoreKey().getType().singularEndpointName(), entryDTO.getStoreKey().getName(), entryDTO.getPath()}));
        }
        catch (MalformedURLException e) {
            this.logger.warn(String.format("Cannot formulate local URL!\n  Base URL: %s\n  Store: %s\n  Path: %s\n  Record: %s\n  Reason: %s", apiBaseUrl, entry.getStoreKey(), entry.getPath(), entry.getTrackingKey(), e.getMessage()), (Throwable)e);
        }
        entryDTO.setOriginUrl(entry.getOriginUrl());
        entryDTO.setMd5(entry.getMd5());
        entryDTO.setSha1(entry.getSha1());
        entryDTO.setSha256(entry.getSha256());
        entryDTO.setSize(entry.getSize());
        entryDTO.setTimestamps(entry.getTimestamps());
        return entryDTO;
    }

    public boolean hasRecord(String id) {
        return this.recordManager.hasRecord(new TrackingKey(id));
    }

    public TrackingIdsDTO getTrackingIds(Set<FoloConstants.TRACKING_TYPE> types) {
        Set inProgress = null;
        if (types.contains((Object)FoloConstants.TRACKING_TYPE.IN_PROGRESS)) {
            inProgress = this.recordManager.getInProgressTrackingKey().stream().map(TrackingKey::getId).collect(Collectors.toSet());
        }
        Set sealed = null;
        if (types.contains((Object)FoloConstants.TRACKING_TYPE.SEALED)) {
            sealed = this.recordManager.getSealedTrackingKey().stream().map(TrackingKey::getId).collect(Collectors.toSet());
        }
        if (inProgress != null && !inProgress.isEmpty() || sealed != null && !sealed.isEmpty()) {
            return new TrackingIdsDTO(inProgress, sealed);
        }
        return null;
    }

    public TrackedContentDTO recalculateRecord(String id, String baseUrl) throws IndyWorkflowException {
        TrackingKey trackingKey = new TrackingKey(id);
        TrackedContent record = this.recordManager.get(trackingKey);
        AtomicBoolean failed = new AtomicBoolean(false);
        Set<TrackedContentEntry> recalculatedUploads = this.recalculateEntrySet(record.getUploads(), id, failed);
        Set<TrackedContentEntry> recalculatedDownloads = null;
        if (!failed.get()) {
            recalculatedDownloads = this.recalculateEntrySet(record.getDownloads(), id, failed);
        }
        if (failed.get()) {
            throw new IndyWorkflowException("Failed to recalculate tracking record: %s. See Indy logs for more information", new Object[]{id});
        }
        TrackedContent recalculated = new TrackedContent(record.getKey(), recalculatedUploads, recalculatedDownloads);
        this.recordManager.replaceTrackingRecord(recalculated);
        return this.constructContentDTO(recalculated, baseUrl);
    }

    private Set<TrackedContentEntry> recalculateEntrySet(Set<TrackedContentEntry> entries, String id, AtomicBoolean failed) throws IndyWorkflowException {
        if (entries == null) {
            return null;
        }
        DrainingExecutorCompletionService recalculateService = new DrainingExecutorCompletionService((ExecutorService)this.recalculationExecutor);
        PoolUtils.detectOverloadVoid(() -> entries.forEach(entry -> recalculateService.submit(() -> {
            try {
                return this.recalculate((TrackedContentEntry)entry);
            }
            catch (IndyWorkflowException e) {
                this.logger.error(String.format("Tracking record: %s : Failed to recalculate: %s/%s (%s). Reason: %s", id, entry.getStoreKey(), entry.getPath(), entry.getEffect(), e.getMessage()), (Throwable)e);
                failed.set(true);
                return null;
            }
        })));
        HashSet<TrackedContentEntry> result = new HashSet<TrackedContentEntry>();
        try {
            recalculateService.drain(entry -> {
                if (entry != null) {
                    result.add((TrackedContentEntry)entry);
                }
            });
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.error("Failed to recalculate metadata for Folo tracked content entries in: " + id, (Throwable)e);
            failed.set(true);
        }
        return result;
    }

    private TrackedContentEntry recalculate(TrackedContentEntry entry) throws IndyWorkflowException {
        StoreKey affectedStore = entry.getStoreKey();
        String path = entry.getPath();
        AccessChannel channel = entry.getAccessChannel();
        Transfer transfer = this.contentManager.getTransfer(affectedStore, path, entry.getEffect() == StoreEffect.UPLOAD ? TransferOperation.UPLOAD : TransferOperation.DOWNLOAD);
        if (transfer == null) {
            return entry;
        }
        this.contentDigester.removeMetadata(transfer);
        TransferMetadata artifactData = this.contentDigester.digest(affectedStore, path, new EventMetadata(affectedStore.getPackageType()));
        Map digests = artifactData.getDigests();
        return new TrackedContentEntry(entry.getTrackingKey(), affectedStore, channel, entry.getOriginUrl(), path, entry.getEffect(), artifactData.getSize(), (String)digests.get(ContentDigest.MD5), (String)digests.get(ContentDigest.SHA_1), (String)digests.get(ContentDigest.SHA_256));
    }

    public void saveToSerialized(TrackingKey key, TrackedContent value) throws IOException {
        File dir = this.filer.getBackupDir(FoloConstants.TRACKING_TYPE.SEALED.getValue()).getDetachedFile();
        File file = new File(dir, key.getId());
        try (FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy((InputStream)FoloUtils.toInputStream(value), (OutputStream)fos);
        }
    }

    public void removeFromSerialized(TrackingKey key) {
        File dir = this.filer.getBackupDir(FoloConstants.TRACKING_TYPE.SEALED.getValue()).getDetachedFile();
        File file = new File(dir, key.getId());
        if (file.exists()) {
            file.delete();
        }
    }
}

