/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.conf;

import java.io.File;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import org.commonjava.indy.conf.IndyConfigInfo;
import org.commonjava.propulsor.config.annotation.ConfigName;
import org.commonjava.propulsor.config.annotation.SectionName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SectionName(value="folo")
@ApplicationScoped
public class FoloConfig
implements IndyConfigInfo {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_DISABLED = false;
    public static final String DEFAULT_FOLO_CASSANDRA_KEYSPACE = "folo";
    public static final String DEFAULT_FOLO_CASSANDRA_TABLENAME = "records";
    private Boolean enabled;
    private Boolean storeToCassandra;
    private Boolean trackGroupContent;
    private String foloCassandraKeyspace;
    private String foloCassandraTablename;

    public boolean isEnabled() {
        return this.enabled == null ? true : this.enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    @ConfigName(value="enabled")
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isGroupContentTracked() {
        return Boolean.TRUE.equals(this.trackGroupContent);
    }

    @ConfigName(value="track.group.content")
    public void setTrackGroupContent(Boolean trackGroupContent) {
        this.trackGroupContent = trackGroupContent;
    }

    public Boolean getTrackGroupContent() {
        return this.trackGroupContent;
    }

    public String getFoloCassandraKeyspace() {
        return this.foloCassandraKeyspace == null ? DEFAULT_FOLO_CASSANDRA_KEYSPACE : this.foloCassandraKeyspace;
    }

    @ConfigName(value="folo.cassandra.keyspace")
    public void setFoloCassandraKeyspace(String foloCassandraKeyspace) {
        this.logger.warn("\n\n-- SETING FOLO KEYSPACE NAME: " + foloCassandraKeyspace);
        this.foloCassandraKeyspace = foloCassandraKeyspace;
    }

    public String getFoloCassandraTablename() {
        return this.foloCassandraTablename == null ? DEFAULT_FOLO_CASSANDRA_TABLENAME : this.foloCassandraTablename;
    }

    @ConfigName(value="folo.cassandra.tablename")
    public void setFoloCassandraTablename(String foloCassandraTablename) {
        this.foloCassandraTablename = foloCassandraTablename;
    }

    public String getDefaultConfigFileName() {
        return new File("conf.d", "folo.conf").getPath();
    }

    public InputStream getDefaultConfig() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("default-folo.conf");
    }
}

