/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.commonjava.indy.core.conf.IndyDurableStateConfig;
import org.commonjava.indy.folo.data.FoloRecord;
import org.commonjava.indy.folo.data.FoloStoreToCassandra;
import org.commonjava.indy.folo.data.FoloStoretoInfinispan;
import org.commonjava.indy.folo.model.StoreEffect;
import org.commonjava.indy.folo.model.TrackedContent;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.subsys.datafile.conf.DataFileConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoloISPN2CassandraMigrationAction {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String COMPLETED_FILE = "folo/completed.out";
    private static final String FAILED_FILE = "folo/failed.out";
    @Inject
    @FoloStoreToCassandra
    FoloRecord dbRecord;
    @Inject
    @FoloStoretoInfinispan
    FoloRecord cacheRecord;
    @Inject
    IndyDurableStateConfig durableConfig;
    @Inject
    DataFileConfiguration dataFileConfiguration;
    private volatile boolean started;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean migrate() {
        if (!"cassandra".equals(this.durableConfig.getFoloStorage())) {
            this.logger.info("Skip the migration if the storage is not cassandra. ");
            return true;
        }
        if (this.started) {
            this.logger.info("Migration is already started. ");
            return true;
        }
        this.logger.info("Migrate folo records from ISPN to cassandra start");
        AtomicInteger count = new AtomicInteger(0);
        HashMap<String, String> failed = new HashMap<String, String>();
        HashSet<String> completed = new HashSet<String>();
        try {
            this.started = true;
            Set<String> prevCompleted = this.loadPrevCompleted();
            Set<TrackingKey> keySet = this.cacheRecord.getSealedTrackingKey();
            this.logger.info("Get total records size: {}", (Object)keySet.size());
            keySet.forEach(key -> {
                if (!prevCompleted.contains(key.getId())) {
                    this.migrateForKey((TrackingKey)key, count, (Set<String>)completed, (Map<String, String>)failed);
                }
            });
            this.logger.info("{}", (Object)count.get());
            this.logger.info("Migrate folo records from ISPN to cassandra done. Failed: {}\n{}", (Object)failed.size(), failed);
        }
        catch (IOException e) {
            this.logger.error("Migration failed", (Throwable)e);
        }
        finally {
            this.started = false;
            this.dumpResult(completed, failed);
        }
        return true;
    }

    private Set<String> loadPrevCompleted() throws IOException {
        HashSet<String> ret = new HashSet<String>();
        File prevCompleted = this.getDataFile(COMPLETED_FILE);
        if (prevCompleted.exists()) {
            try (FileInputStream is = new FileInputStream(prevCompleted);){
                ret.addAll(IOUtils.readLines((InputStream)is));
            }
        }
        this.logger.info("Load prev completed, size: {}", (Object)ret.size());
        return ret;
    }

    private void dumpResult(Set<String> completed, Map<String, String> failed) {
        Throwable throwable;
        FileOutputStream os;
        try {
            os = new FileOutputStream(this.getDataFile(COMPLETED_FILE), true);
            throwable = null;
            try {
                IOUtils.writeLines(completed, (String)IOUtils.LINE_SEPARATOR, (OutputStream)os);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (os != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((OutputStream)os).close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to dump completed", (Throwable)e);
        }
        try {
            os = new FileOutputStream(this.getDataFile(FAILED_FILE));
            throwable = null;
            try {
                IOUtils.writeLines(failed.keySet(), (String)IOUtils.LINE_SEPARATOR, (OutputStream)os);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (os != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((OutputStream)os).close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to dump failed", (Throwable)e);
        }
    }

    private File getDataFile(String path) {
        return new File(this.dataFileConfiguration.getDataBasedir(), path);
    }

    private void migrateForKey(TrackingKey key, AtomicInteger count, Set<String> completed, Map<String, String> failed) {
        try {
            TrackedContent item = this.cacheRecord.get(key);
            if (item != null) {
                this.amendTrackingKeyAndEffect(item);
                this.dbRecord.addSealedRecord(item);
                int index = count.incrementAndGet();
                if (index % 10 == 0) {
                    this.logger.info("{}", (Object)index);
                }
                completed.add(key.getId());
            } else {
                this.logger.warn("Folo content missing, key: {}", (Object)key);
                failed.put(key.getId(), "content missing");
            }
        }
        catch (Throwable e) {
            this.logger.error("Folo content migrate failed, key: " + key, e);
            failed.put(key.getId(), e.toString());
        }
    }

    private void amendTrackingKeyAndEffect(TrackedContent item) {
        Set downloads;
        TrackingKey key = item.getKey();
        Set uploads = item.getUploads();
        if (uploads != null) {
            uploads.forEach(up -> {
                if (up.getTrackingKey() == null) {
                    up.setTrackingKey(key);
                }
                if (up.getEffect() == null) {
                    up.setEffect(StoreEffect.UPLOAD);
                }
            });
        }
        if ((downloads = item.getDownloads()) != null) {
            downloads.forEach(down -> {
                if (down.getTrackingKey() == null) {
                    down.setTrackingKey(key);
                }
                if (down.getEffect() == null) {
                    down.setEffect(StoreEffect.DOWNLOAD);
                }
            });
        }
    }
}

