/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.commonjava.indy.folo.ctl.FoloConstants;
import org.commonjava.indy.folo.model.TrackedContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoloUtils {
    private static final Logger logger = LoggerFactory.getLogger(FoloUtils.class);

    public static void zipTrackedContent(File out, Set<TrackedContent> sealed) throws IOException {
        logger.info("Writing sealed zip to: '{}'", (Object)out.getAbsolutePath());
        try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(out));){
            for (TrackedContent f : sealed) {
                String name = FoloConstants.TRACKING_TYPE.SEALED.getValue() + "/" + f.getKey().getId();
                logger.trace("Adding {} to zip", (Object)name);
                zip.putNextEntry(new ZipEntry(name));
                IOUtils.copy((InputStream)FoloUtils.toInputStream(f), (OutputStream)zip);
            }
        }
    }

    public static void backupTrackedContent(File dir, Set<TrackedContent> sealed) throws IOException {
        logger.info("Backup sealed to: '{}', size: {}", (Object)dir.getAbsolutePath(), (Object)sealed.size());
        for (TrackedContent f : sealed) {
            String name = f.getKey().getId();
            logger.trace("Adding {} to {}", (Object)name, (Object)dir);
            FileOutputStream out = new FileOutputStream(new File(dir, name));
            Throwable throwable = null;
            try {
                IOUtils.copy((InputStream)FoloUtils.toInputStream(f), (OutputStream)out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((OutputStream)out).close();
            }
        }
    }

    public static int readZipInputStreamAnd(InputStream inputStream, Consumer<TrackedContent> consumer) throws IOException, ClassNotFoundException {
        int count = 0;
        try (ZipInputStream stream = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                int len;
                logger.trace("Read entry: %s, len: %d", (Object)entry.getName(), (Object)entry.getSize());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = stream.read(buffer)) > 0) {
                    bos.write(buffer, 0, len);
                }
                bos.close();
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
                TrackedContent record = (TrackedContent)ois.readObject();
                consumer.accept(record);
                ++count;
            }
        }
        return count;
    }

    public static InputStream toInputStream(TrackedContent f) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(f);
        oos.flush();
        oos.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

