/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.change;

import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.indy.folo.ctl.FoloAdminController;
import org.commonjava.indy.folo.model.TrackedContent;
import org.commonjava.indy.folo.model.TrackingKey;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Listener
@ApplicationScoped
public class FoloBackupListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private FoloAdminController adminController;

    public FoloBackupListener(FoloAdminController adminController) {
        this.adminController = adminController;
    }

    public FoloBackupListener() {
    }

    @CacheEntryCreated
    public void onCacheEntryCreated(CacheEntryCreatedEvent<TrackingKey, TrackedContent> event) {
        if (event.isPre()) {
            return;
        }
        this.logger.debug("Cache entry with key {} added in cache {}", event.getKey(), (Object)event.getCache());
        try {
            this.adminController.saveToSerialized((TrackingKey)event.getKey(), (TrackedContent)event.getValue());
        }
        catch (IOException e) {
            this.logger.warn("[Folo] saveToSerialize fail", (Throwable)e);
        }
    }

    @CacheEntryModified
    public void onCacheEntryModified(CacheEntryModifiedEvent<TrackingKey, TrackedContent> event) {
        if (event.isPre()) {
            return;
        }
        this.logger.debug("Cache entry with key {} updated in cache {}", event.getKey(), (Object)event.getCache());
        try {
            this.adminController.saveToSerialized((TrackingKey)event.getKey(), (TrackedContent)event.getValue());
        }
        catch (IOException e) {
            this.logger.warn("[Folo] saveToSerialize fail", (Throwable)e);
        }
    }

    @CacheEntryRemoved
    public void onCacheEntryRemoved(CacheEntryRemovedEvent<TrackingKey, TrackedContent> event) {
        if (event.isPre()) {
            return;
        }
        TrackingKey key = (TrackingKey)event.getKey();
        this.logger.debug("Cache entry with key {} removed in cache {}", (Object)key, (Object)event.getCache());
        this.adminController.removeFromSerialized(key);
    }
}

