/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.data.idxmodel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import org.commonjava.indy.folo.model.TrackedContentEntry;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.io.IndyObjectMapper;
import org.hibernate.search.bridge.TwoWayStringBridge;

public class StoreKeyFieldBridge
implements TwoWayStringBridge {
    @Inject
    private ObjectMapper objMapper;

    public StoreKeyFieldBridge() {
        this.initMapper();
    }

    private void initMapper() {
        if (this.objMapper == null) {
            CDI cdi = CDI.current();
            this.objMapper = (ObjectMapper)cdi.select(IndyObjectMapper.class, new Annotation[0]).get();
        }
    }

    public Object stringToObject(String stringValue) {
        if ("".equals(stringValue)) {
            return null;
        }
        try {
            return this.objMapper.readValue(stringValue, TrackedContentEntry.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String objectToString(Object object) {
        if (object instanceof StoreKey) {
            try {
                return this.objMapper.writeValueAsString(object);
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException(e);
            }
        }
        return "";
    }
}

