/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.action;

import java.io.File;
import javax.inject.Inject;
import org.commonjava.indy.IndyWorkflowException;
import org.commonjava.indy.action.IndyLifecycleException;
import org.commonjava.indy.action.StartupAction;
import org.commonjava.indy.folo.ctl.FoloAdminController;
import org.commonjava.indy.folo.ctl.FoloConstants;
import org.commonjava.indy.folo.data.FoloFiler;

public class BackupStartupAction
implements StartupAction {
    @Inject
    private FoloFiler filer;
    @Inject
    private FoloAdminController adminController;

    public void start() throws IndyLifecycleException {
        File dir = this.filer.getBackupDir(FoloConstants.TRACKING_TYPE.SEALED.getValue()).getDetachedFile();
        if (!dir.isDirectory()) {
            dir.mkdirs();
            try {
                this.adminController.doInitialBackUpForSealed();
            }
            catch (IndyWorkflowException e) {
                throw new IndyLifecycleException("doInitialBackUpForSealed fail", (Throwable)e, new Object[0]);
            }
        }
    }

    public String getId() {
        return "folo-backup-sealed-records";
    }

    public int getStartupPriority() {
        return 90;
    }
}

