/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.data;

import java.io.File;
import javax.inject.Inject;
import org.commonjava.indy.folo.data.FoloFileTypes;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.subsys.datafile.DataFile;
import org.commonjava.indy.subsys.datafile.DataFileManager;

public class FoloFiler {
    public static final String FOLO_DIR = "folo";
    public static final String FOLO_SEALED_ZIP = "folo-sealed.zip";
    public static final String FOLO_SEALED_DAT = "folo-sealed.dat";
    @Inject
    private DataFileManager dataFileManager;

    protected FoloFiler() {
    }

    public FoloFiler(DataFileManager dataFileManager) {
        this.dataFileManager = dataFileManager;
    }

    public DataFile getRecordFile(TrackingKey key) {
        return this.getDataFile(key, "json");
    }

    private DataFile getDataFile(TrackingKey key, String ext) {
        String fname = String.format("%s.%s", key.getId(), ext);
        return this.dataFileManager.getDataFile(new String[]{FOLO_DIR, fname});
    }

    public DataFile getRepositoryZipFile(TrackingKey key) {
        return this.getDataFile(key, "repo.zip");
    }

    public DataFile getSealedZipFile() {
        return this.dataFileManager.getDataFile(new String[]{FOLO_DIR, FOLO_SEALED_ZIP});
    }

    public DataFile getSealedDataFile() {
        return this.dataFileManager.getDataFile(new String[]{FOLO_DIR, FOLO_SEALED_DAT});
    }

    public void deleteFiles(TrackingKey key) {
        for (String ext : FoloFileTypes.TYPES) {
            File f = this.getDataFile(key, ext).getDetachedFile();
            if (!f.exists()) continue;
            f.delete();
        }
    }
}

