/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.data;

import java.lang.annotation.ElementType;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.commonjava.indy.folo.data.FoloInprogressCache;
import org.commonjava.indy.folo.data.FoloSealedCache;
import org.commonjava.indy.folo.data.idxmodel.StoreKeyFieldBridge;
import org.commonjava.indy.folo.data.idxmodel.TrackedContentEntryTransformer;
import org.commonjava.indy.folo.model.TrackedContent;
import org.commonjava.indy.folo.model.TrackedContentEntry;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.subsys.datafile.conf.DataFileConfiguration;
import org.commonjava.indy.subsys.infinispan.CacheHandle;
import org.commonjava.indy.subsys.infinispan.CacheProducer;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.cfg.SearchMapping;
import org.infinispan.Cache;
import org.infinispan.query.Search;
import org.infinispan.query.spi.SearchManagerImplementor;

public class FoloCacheProducer {
    private static final String SEALED_NAME = "folo-sealed";
    private static final String IN_PROGRESS_NAME = "folo-in-progress";
    @Inject
    private CacheProducer cacheProducer;
    @Inject
    private DataFileConfiguration dataConfig;

    @PostConstruct
    public void initIndexing() {
        this.registerTransformer();
    }

    @Factory
    public SearchMapping getSearchMapping() {
        SearchMapping entryMapping = new SearchMapping();
        entryMapping.entity(TrackedContentEntry.class).indexed().property("storeKey", ElementType.METHOD).field().bridge(StoreKeyFieldBridge.class).property("accessChannel", ElementType.METHOD).field().property("path", ElementType.METHOD).field().property("originUrl", ElementType.METHOD).field().property("effect", ElementType.METHOD).field().property("md5", ElementType.METHOD).field().property("sha256", ElementType.METHOD).field().property("sha1", ElementType.METHOD).field().property("size", ElementType.METHOD).field().property("index", ElementType.METHOD).field().analyze(Analyze.NO).property("trackingKey", ElementType.METHOD).indexEmbedded().entity(TrackingKey.class).indexed().property("id", ElementType.METHOD).field().analyze(Analyze.NO);
        return entryMapping;
    }

    private void registerTransformer() {
        CacheHandle handler = this.cacheProducer.getCache(IN_PROGRESS_NAME, TrackedContentEntry.class, TrackedContentEntry.class);
        handler.execute(cache -> {
            SearchManagerImplementor searchManager = (SearchManagerImplementor)Search.getSearchManager((Cache)cache);
            searchManager.registerKeyTransformer(TrackedContentEntry.class, TrackedContentEntryTransformer.class);
            return null;
        });
    }

    @FoloInprogressCache
    @Produces
    @ApplicationScoped
    public CacheHandle<TrackedContentEntry, TrackedContentEntry> inProgressFoloRecordCacheCfg() {
        return this.cacheProducer.getCache(IN_PROGRESS_NAME, TrackedContentEntry.class, TrackedContentEntry.class);
    }

    @FoloSealedCache
    @Produces
    @ApplicationScoped
    public CacheHandle<TrackingKey, TrackedContent> sealedFoloRecordCacheCfg() {
        return this.cacheProducer.getCache(SEALED_NAME, TrackingKey.class, TrackedContent.class);
    }
}

