/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.change;

import java.net.MalformedURLException;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.commonjava.indy.IndyWorkflowException;
import org.commonjava.indy.content.ContentDigester;
import org.commonjava.indy.content.DownloadManager;
import org.commonjava.indy.data.IndyDataException;
import org.commonjava.indy.data.StoreDataManager;
import org.commonjava.indy.folo.conf.FoloConfig;
import org.commonjava.indy.folo.data.FoloContentException;
import org.commonjava.indy.folo.data.FoloRecordCache;
import org.commonjava.indy.folo.model.StoreEffect;
import org.commonjava.indy.folo.model.TrackedContentEntry;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.model.core.AccessChannel;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.indy.model.galley.KeyedLocation;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.event.FileAccessEvent;
import org.commonjava.maven.galley.event.FileStorageEvent;
import org.commonjava.maven.galley.io.checksum.ContentDigest;
import org.commonjava.maven.galley.io.checksum.TransferMetadata;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.util.UrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FoloTrackingListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private FoloConfig foloConfig;
    @Inject
    private FoloRecordCache recordManager;
    @Inject
    private StoreDataManager storeManager;
    @Inject
    private DownloadManager downloadManager;
    @Inject
    private ContentDigester contentDigester;

    public void onFileAccess(@Observes FileAccessEvent event) {
        this.logger.trace("FILE ACCESS: {}", (Object)event);
        EventMetadata metadata = event.getEventMetadata();
        TrackingKey trackingKey = (TrackingKey)metadata.get((Object)"tracking-id");
        if (trackingKey == null) {
            this.logger.trace("No tracking key for access to: {}", (Object)event.getTransfer());
            return;
        }
        AccessChannel accessChannel = (AccessChannel)metadata.get((Object)"access-channel");
        Transfer transfer = event.getTransfer();
        if (transfer == null) {
            this.logger.trace("No transfer: {}", (Object)event);
            return;
        }
        Location location = transfer.getLocation();
        if (!(location instanceof KeyedLocation)) {
            this.logger.trace("Not in a keyed location: {}", (Object)event.getTransfer());
            return;
        }
        try {
            KeyedLocation keyedLocation = (KeyedLocation)location;
            if (!this.foloConfig.isGroupContentTracked() && keyedLocation.getKey().getType() == StoreType.group) {
                this.logger.trace("NOT tracking content stored directly in group: {}. This content is generally aggregated metadata, and can be recalculated. Groups may not be stable in some build environments", (Object)keyedLocation.getKey());
                return;
            }
            this.logger.trace("Tracking report: {} += {} in {} (DOWNLOAD)", new Object[]{trackingKey, transfer.getPath(), keyedLocation.getKey()});
            this.recordManager.recordArtifact(this.createEntry(trackingKey, keyedLocation.getKey(), accessChannel, transfer.getPath(), StoreEffect.DOWNLOAD, event.getEventMetadata()));
        }
        catch (IndyWorkflowException | FoloContentException e) {
            this.logger.error(String.format("Failed to record download: %s. Reason: %s", transfer, e.getMessage()), e);
        }
    }

    public void onFileUpload(@Observes FileStorageEvent event) {
        this.logger.trace("FILE STORAGE: {}", (Object)event);
        if (TransferOperation.UPLOAD != event.getType()) {
            this.logger.trace("Not a file upload from client; skipping tracking of storage");
            return;
        }
        EventMetadata metadata = event.getEventMetadata();
        TrackingKey trackingKey = (TrackingKey)metadata.get((Object)"tracking-id");
        if (trackingKey == null) {
            this.logger.trace("No tracking key. Not recording.");
            return;
        }
        AccessChannel accessChannel = (AccessChannel)metadata.get((Object)"access-channel");
        Transfer transfer = event.getTransfer();
        if (transfer == null) {
            this.logger.trace("No transfer. Not recording.");
            return;
        }
        Location location = transfer.getLocation();
        if (!(location instanceof KeyedLocation)) {
            this.logger.trace("Invalid transfer source location: {}. Not recording.", (Object)location);
            return;
        }
        if (!this.foloConfig.isGroupContentTracked() && ((KeyedLocation)location).getKey().getType() == StoreType.group) {
            this.logger.trace("NOT tracking content stored directly in group: {}. This content is generally aggregated metadata, and can be recalculated. Groups may not be stable in some build environments", (Object)((KeyedLocation)location).getKey());
            return;
        }
        TransferOperation op = event.getType();
        StoreEffect effect = null;
        switch (op) {
            case DOWNLOAD: {
                effect = StoreEffect.DOWNLOAD;
                break;
            }
            case UPLOAD: {
                effect = StoreEffect.UPLOAD;
                break;
            }
            default: {
                this.logger.trace("Ignoring transfer operation: {} for: {}", (Object)op, (Object)transfer);
                return;
            }
        }
        try {
            KeyedLocation keyedLocation = (KeyedLocation)location;
            this.logger.trace("Tracking report: {} += {} in {} ({})", new Object[]{trackingKey, transfer.getPath(), keyedLocation.getKey(), effect});
            this.recordManager.recordArtifact(this.createEntry(trackingKey, keyedLocation.getKey(), accessChannel, transfer.getPath(), effect, event.getEventMetadata()));
        }
        catch (IndyWorkflowException | FoloContentException e) {
            this.logger.error(String.format("Failed to record download: %s. Reason: %s", transfer, e.getMessage()), e);
        }
    }

    private TrackedContentEntry createEntry(TrackingKey trackingKey, StoreKey affectedStore, AccessChannel accessChannel, String path, StoreEffect effect, EventMetadata eventMetadata) throws IndyWorkflowException {
        TrackedContentEntry entry = null;
        Transfer txfr = this.downloadManager.getStorageReference(affectedStore, new String[]{path});
        if (txfr != null) {
            try {
                RemoteRepository repo;
                String remoteUrl = null;
                if (StoreType.remote == affectedStore.getType() && (repo = (RemoteRepository)this.storeManager.getArtifactStore(affectedStore)) != null) {
                    remoteUrl = UrlUtils.buildUrl((String)repo.getUrl(), (String[])new String[]{path});
                }
                TransferMetadata artifactData = this.contentDigester.digest(affectedStore, path, eventMetadata);
                Map digests = artifactData.getDigests();
                entry = new TrackedContentEntry(trackingKey, affectedStore, accessChannel, remoteUrl, path, effect, artifactData.getSize(), (String)digests.get(ContentDigest.MD5), (String)digests.get(ContentDigest.SHA_1), (String)digests.get(ContentDigest.SHA_256));
            }
            catch (IndyDataException e) {
                throw new IndyWorkflowException("Cannot retrieve RemoteRepository: %s to calculate remote URL for: %s. Reason: %s", (Throwable)e, new Object[]{trackingKey, path, e.getMessage()});
            }
            catch (MalformedURLException e) {
                throw new IndyWorkflowException("Cannot format URL. Reason: %s", (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return entry;
    }
}

