/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.data;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.indy.IndyWorkflowException;
import org.commonjava.indy.folo.data.FoloContentException;
import org.commonjava.indy.folo.data.FoloInprogressCache;
import org.commonjava.indy.folo.data.FoloSealedCache;
import org.commonjava.indy.folo.model.StoreEffect;
import org.commonjava.indy.folo.model.TrackedContent;
import org.commonjava.indy.folo.model.TrackedContentEntry;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.measure.annotation.IndyMetrics;
import org.commonjava.indy.measure.annotation.Measure;
import org.commonjava.indy.measure.annotation.MetricNamed;
import org.commonjava.indy.subsys.infinispan.CacheHandle;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.cdi.ConfigureCache;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FoloRecordCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @FoloInprogressCache
    @Inject
    private CacheHandle<TrackedContentEntry, TrackedContentEntry> inProgressRecordCache;
    @ConfigureCache(value="folo-sealed")
    @FoloSealedCache
    @Inject
    private CacheHandle<TrackingKey, TrackedContent> sealedRecordCache;

    protected FoloRecordCache() {
    }

    public FoloRecordCache(Cache<TrackedContentEntry, TrackedContentEntry> inProgressRecordCache, Cache<TrackingKey, TrackedContent> sealedRecordCache) {
        this.inProgressRecordCache = new CacheHandle("folo-in-progress", inProgressRecordCache);
        this.sealedRecordCache = new CacheHandle("folo-sealed", sealedRecordCache);
    }

    @IndyMetrics(measure=@Measure(meters={@MetricNamed(name="org.commonjava.indy.folo.foloRecordCache.recordArtifact.meter")}, timers={@MetricNamed(name="org.commonjava.indy.folo.foloRecordCache.recordArtifact.timer")}))
    public synchronized boolean recordArtifact(TrackedContentEntry entry) throws FoloContentException, IndyWorkflowException {
        if (this.sealedRecordCache.containsKey((Object)entry.getTrackingKey())) {
            throw new FoloContentException("Tracking record: {} is already sealed!", entry.getTrackingKey());
        }
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.debug("Trying to add tracking entry: {}", (Object)entry);
        if (!this.inProgressRecordCache.containsKey((Object)entry)) {
            logger.debug("Adding: {}", (Object)entry);
            this.inProgressRecordCache.put((Object)entry, (Object)entry);
            return true;
        }
        logger.debug("record already contains entry: {} (existing: {})", (Object)entry, this.inProgressRecordCache.get((Object)entry));
        return false;
    }

    @IndyMetrics(measure=@Measure(meters={@MetricNamed(name="org.commonjava.indy.folo.foloRecordCache.delete.meter")}, timers={@MetricNamed(name="org.commonjava.indy.folo.foloRecordCache.delete.timer")}))
    public synchronized void delete(TrackingKey key) {
        this.sealedRecordCache.remove((Object)key);
        this.inProgressByTrackingKey(key, (qb, ch) -> {
            qb.build().list().forEach(item -> {
                TrackedContentEntry cfr_ignored_0 = (TrackedContentEntry)ch.execute(cache -> (TrackedContentEntry)cache.remove(item));
            });
            return false;
        });
    }

    public synchronized void replaceTrackingRecord(TrackedContent record) {
        this.sealedRecordCache.put((Object)record.getKey(), (Object)record);
    }

    public synchronized boolean hasRecord(TrackingKey key) {
        return this.hasSealedRecord(key) || this.hasInProgressRecord(key);
    }

    public synchronized boolean hasSealedRecord(TrackingKey key) {
        return this.sealedRecordCache.containsKey((Object)key);
    }

    @IndyMetrics(measure=@Measure(meters={@MetricNamed(name="org.commonjava.indy.folo.foloRecordCache.hasInProgressRecord.meter")}, timers={@MetricNamed(name="org.commonjava.indy.folo.foloRecordCache.hasInProgressRecord.timer")}))
    public synchronized boolean hasInProgressRecord(TrackingKey key) {
        return !this.sealedRecordCache.containsKey((Object)key) && this.inProgressByTrackingKey(key, (qb, cacheHandle) -> qb.build().getResultSize() > 0) != false;
    }

    public synchronized TrackedContent get(TrackingKey key) {
        return (TrackedContent)this.sealedRecordCache.get((Object)key);
    }

    @IndyMetrics(measure=@Measure(meters={@MetricNamed(name="org.commonjava.indy.folo.foloRecordCache.seal.meter")}, timers={@MetricNamed(name="org.commonjava.indy.folo.foloRecordCache.seal.timer")}))
    public TrackedContent seal(TrackingKey trackingKey) {
        TrackedContent record = (TrackedContent)this.sealedRecordCache.get((Object)trackingKey);
        Logger logger = LoggerFactory.getLogger(this.getClass());
        if (record != null) {
            logger.debug("Tracking record: {} already sealed! Returning sealed record.", (Object)trackingKey);
            return record;
        }
        logger.debug("Listing unsealed tracking record entries for: {}...", (Object)trackingKey);
        return this.inProgressByTrackingKey(trackingKey, (qb, cacheHandle) -> {
            Query query = qb.build();
            List results = query.list();
            TrackedContent created = null;
            if (results != null) {
                logger.debug("Adding {} entries to record: {}", (Object)results.size(), (Object)trackingKey);
                TreeSet uploads = new TreeSet();
                TreeSet downloads = new TreeSet();
                results.forEach(result -> {
                    if (StoreEffect.DOWNLOAD == result.getEffect()) {
                        downloads.add(result);
                    } else if (StoreEffect.UPLOAD == result.getEffect()) {
                        uploads.add(result);
                    }
                    logger.debug("Removing in-progress entry: {}", result);
                    this.inProgressRecordCache.remove(result);
                });
                created = new TrackedContent(trackingKey, uploads, downloads);
            }
            logger.debug("Sealing record for: {}", (Object)trackingKey);
            this.sealedRecordCache.put((Object)trackingKey, created);
            return created;
        });
    }

    public Set<TrackingKey> getInProgressTrackingKey() {
        return ((CacheSet)this.inProgressRecordCache.execute(Cache::keySet)).stream().map(TrackedContentEntry::getTrackingKey).collect(Collectors.toSet());
    }

    public Set<TrackingKey> getSealedTrackingKey() {
        return (Set)this.sealedRecordCache.execute(Cache::keySet);
    }

    private <R> R inProgressByTrackingKey(TrackingKey key, BiFunction<QueryBuilder, CacheHandle<TrackedContentEntry, TrackedContentEntry>, R> operation) {
        return (R)this.inProgressRecordCache.execute(cache -> {
            QueryFactory queryFactory = Search.getQueryFactory((Cache)cache);
            QueryBuilder qb = queryFactory.from(TrackedContentEntry.class).having("trackingKey.id").eq((Object)key.getId()).toBuilder();
            return operation.apply(qb, this.inProgressRecordCache);
        });
    }
}

