/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.data;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.indy.folo.conf.FoloConfig;
import org.commonjava.indy.folo.data.FoloContentException;
import org.commonjava.indy.folo.data.FoloFiler;
import org.commonjava.indy.folo.model.AffectedStoreRecord;
import org.commonjava.indy.folo.model.StoreEffect;
import org.commonjava.indy.folo.model.TrackedContentRecord;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.io.IndyObjectMapper;
import org.commonjava.indy.subsys.datafile.DataFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FoloRecordCache
extends CacheLoader<TrackingKey, TrackedContentRecord>
implements RemovalListener<TrackingKey, TrackedContentRecord> {
    private static final String JSON_TYPE = "json";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    private IndyObjectMapper objectMapper;
    @Inject
    private FoloConfig config;
    @Inject
    private FoloFiler filer;
    protected Cache<TrackingKey, TrackedContentRecord> recordCache;

    protected FoloRecordCache() {
    }

    public FoloRecordCache(FoloFiler filer, IndyObjectMapper objectMapper, FoloConfig config) {
        this.filer = filer;
        this.objectMapper = objectMapper;
        this.config = config;
    }

    @PreDestroy
    public void shutdown() {
        this.recordCache.invalidateAll();
    }

    @PostConstruct
    public void startCache() {
        this.buildCache();
    }

    protected Cache<TrackingKey, TrackedContentRecord> buildCache() {
        return this.buildCache(null);
    }

    protected Cache<TrackingKey, TrackedContentRecord> buildCache(FoloRecordCacheConfigurator builderConfigurator) {
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.removalListener((RemovalListener)this);
        if (builderConfigurator != null) {
            builderConfigurator.configure((CacheBuilder<Object, Object>)builder);
        } else {
            builder.expireAfterAccess((long)this.config.getCacheTimeoutSeconds().intValue(), TimeUnit.SECONDS);
        }
        this.recordCache = builder.build((CacheLoader)this);
        return this.recordCache;
    }

    public synchronized TrackedContentRecord recordArtifact(TrackingKey key, StoreKey affectedStore, String path, StoreEffect effect) throws FoloContentException {
        TrackedContentRecord record;
        try {
            record = (TrackedContentRecord)this.recordCache.get((Object)key, this.newCallable(key));
        }
        catch (ExecutionException e) {
            throw new FoloContentException("Failed to load tracking record for: %s. Reason: %s", (Throwable)e, key, e.getMessage());
        }
        AffectedStoreRecord affected = record.getAffectedStore(affectedStore, true);
        affected.add(path, effect);
        this.recordCache.put((Object)record.getKey(), (Object)record);
        return record;
    }

    private Callable<? extends TrackedContentRecord> newCallable(TrackingKey key) {
        return () -> this.load(key);
    }

    public void onRemoval(RemovalNotification<TrackingKey, TrackedContentRecord> notification) {
        TrackingKey key = (TrackingKey)notification.getKey();
        if (key == null) {
            this.logger.info("Nothing to persist. Skipping.");
            return;
        }
        this.write((TrackedContentRecord)notification.getValue());
    }

    protected void write(TrackedContentRecord record) {
        TrackingKey key = record.getKey();
        File file = this.filer.getRecordFile(key).getDetachedFile();
        this.logger.info("Writing {} to: {}", (Object)key, (Object)file);
        try {
            file.getParentFile().mkdirs();
            this.objectMapper.writeValue(file, (Object)record);
        }
        catch (IOException e) {
            this.logger.error("Failed to persist folo log of artifact usage via: " + key, (Throwable)e);
        }
    }

    public TrackedContentRecord load(TrackingKey key) throws Exception {
        DataFile file = this.filer.getRecordFile(key);
        if (!file.exists()) {
            this.logger.info("Creating new record for: {}", (Object)key);
            return new TrackedContentRecord(key);
        }
        this.logger.info("Loading: {} from: {}", (Object)key, (Object)file);
        try {
            return (TrackedContentRecord)this.objectMapper.readValue(file.getDetachedFile(), TrackedContentRecord.class);
        }
        catch (IOException e) {
            this.logger.error("Failed to read folo tracked record: " + key, (Throwable)e);
            throw new IllegalStateException("Requested artimon tracked record: " + key + " is corrupt, and cannot be read.", e);
        }
    }

    public synchronized void delete(TrackingKey key) {
        this.recordCache.invalidate((Object)key);
        this.filer.deleteFiles(key);
    }

    public synchronized boolean hasRecord(TrackingKey key) {
        DataFile rf = this.filer.getRecordFile(key);
        this.logger.info("Looking for tracking record: {}.\nCache record: {}\nRecord file: {} (exists? {})", new Object[]{key, this.recordCache.getIfPresent((Object)key), rf, rf.exists()});
        return this.recordCache.getIfPresent((Object)key) != null || rf.exists();
    }

    public synchronized TrackedContentRecord getOrCreate(TrackingKey key) throws FoloContentException {
        try {
            return (TrackedContentRecord)this.recordCache.get((Object)key, () -> this.load(key));
        }
        catch (ExecutionException e) {
            throw new FoloContentException("Failed to load tracking record for: %s. Reason: %s", (Throwable)e, key, e.getMessage());
        }
    }

    public synchronized TrackedContentRecord getIfExists(TrackingKey key) {
        DataFile rf = this.filer.getRecordFile(key);
        TrackedContentRecord record = (TrackedContentRecord)this.recordCache.getIfPresent((Object)key);
        this.logger.info("Looking for tracking record: {}.\nCache record: {}\nRecord file: {} (exists? {})", new Object[]{key, record, rf, rf.exists()});
        if (record == null && rf.exists()) {
            try {
                record = (TrackedContentRecord)this.recordCache.get((Object)key, () -> this.load(key));
            }
            catch (ExecutionException e) {
                this.logger.error(String.format("Failed to load Folo tracking record from: %s. Reason: %s", rf, e.getMessage()), (Throwable)e);
                record = null;
            }
        }
        return record;
    }

    public static interface FoloRecordCacheConfigurator {
        public void configure(CacheBuilder<Object, Object> var1);
    }
}

