/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.change;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.commonjava.indy.folo.data.FoloContentException;
import org.commonjava.indy.folo.data.FoloRecordCache;
import org.commonjava.indy.folo.model.StoreEffect;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.model.galley.KeyedLocation;
import org.commonjava.maven.galley.event.FileAccessEvent;
import org.commonjava.maven.galley.event.FileStorageEvent;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoloTrackingListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private FoloRecordCache recordManager;

    public void onFileAccess(@Observes FileAccessEvent event) {
        TrackingKey trackingKey = (TrackingKey)event.getEventMetadata().get((Object)"tracking-id");
        if (trackingKey == null) {
            this.logger.info("No tracking key for access to: {}", (Object)event.getTransfer());
            return;
        }
        Transfer transfer = event.getTransfer();
        if (transfer == null) {
            this.logger.info("No transfer: {}", (Object)event);
            return;
        }
        Location location = transfer.getLocation();
        if (!(location instanceof KeyedLocation)) {
            this.logger.info("Not in a keyed location: {}", (Object)event.getTransfer());
            return;
        }
        try {
            KeyedLocation keyedLocation = (KeyedLocation)location;
            this.logger.debug("Tracking report: {} += {} in {} (DOWNLOAD)", new Object[]{trackingKey, transfer.getPath(), keyedLocation.getKey()});
            this.recordManager.recordArtifact(trackingKey, keyedLocation.getKey(), transfer.getPath(), StoreEffect.DOWNLOAD);
        }
        catch (FoloContentException e) {
            this.logger.error(String.format("Failed to record download: %s. Reason: %s", transfer, e.getMessage()), (Throwable)e);
        }
    }

    public void onFileUpload(@Observes FileStorageEvent event) {
        TrackingKey trackingKey = (TrackingKey)event.getEventMetadata().get((Object)"tracking-id");
        if (trackingKey == null) {
            this.logger.info("No tracking key. Not recording.");
            return;
        }
        Transfer transfer = event.getTransfer();
        if (transfer == null) {
            this.logger.info("No transfer. Not recording.");
            return;
        }
        Location location = transfer.getLocation();
        if (!(location instanceof KeyedLocation)) {
            this.logger.info("Invalid transfer source location: {}. Not recording.", (Object)location);
            return;
        }
        TransferOperation op = event.getType();
        StoreEffect effect = null;
        switch (op) {
            case DOWNLOAD: {
                effect = StoreEffect.DOWNLOAD;
                break;
            }
            case UPLOAD: {
                effect = StoreEffect.UPLOAD;
                break;
            }
            default: {
                this.logger.debug("Ignoring transfer operation: {} for: {}", (Object)op, (Object)transfer);
                return;
            }
        }
        try {
            KeyedLocation keyedLocation = (KeyedLocation)location;
            this.logger.debug("Tracking report: {} += {} in {} ({})", new Object[]{trackingKey, transfer.getPath(), keyedLocation.getKey(), effect});
            this.recordManager.recordArtifact(trackingKey, keyedLocation.getKey(), transfer.getPath(), effect);
        }
        catch (FoloContentException e) {
            this.logger.error(String.format("Failed to record download: %s. Reason: %s", transfer, e.getMessage()), (Throwable)e);
        }
    }
}

