/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ctl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.commonjava.indy.IndyWorkflowException;
import org.commonjava.indy.content.ContentDigest;
import org.commonjava.indy.content.ContentManager;
import org.commonjava.indy.content.DownloadManager;
import org.commonjava.indy.data.IndyDataException;
import org.commonjava.indy.data.StoreDataManager;
import org.commonjava.indy.folo.data.FoloContentException;
import org.commonjava.indy.folo.data.FoloFiler;
import org.commonjava.indy.folo.data.FoloRecordCache;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.dto.TrackedContentEntryDTO;
import org.commonjava.indy.folo.model.AffectedStoreRecord;
import org.commonjava.indy.folo.model.TrackedContentRecord;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.indy.util.ApplicationStatus;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.util.UrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FoloAdminController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private FoloRecordCache recordManager;
    @Inject
    private FoloFiler filer;
    @Inject
    private DownloadManager downloadManager;
    @Inject
    private ContentManager contentManager;
    @Inject
    private StoreDataManager storeManager;

    protected FoloAdminController() {
    }

    public FoloAdminController(FoloRecordCache recordManager, FoloFiler filer, DownloadManager downloadManager, ContentManager contentManager, StoreDataManager storeManager) {
        this.recordManager = recordManager;
        this.filer = filer;
        this.downloadManager = downloadManager;
        this.contentManager = contentManager;
        this.storeManager = storeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File renderRepositoryZip(String id) throws IndyWorkflowException {
        TrackingKey tk = new TrackingKey(id);
        File file = this.filer.getRepositoryZipFile(tk).getDetachedFile();
        file.getParentFile().mkdirs();
        this.logger.debug("Retrieving tracking record for: {}", (Object)tk);
        TrackedContentRecord record = this.recordManager.getIfExists(tk);
        this.logger.debug("Got: {}", (Object)record);
        if (record == null) {
            throw new IndyWorkflowException(ApplicationStatus.NOT_FOUND.code(), "No tracking record available for: %s", new Object[]{tk});
        }
        HashSet<String> seenPaths = new HashSet<String>();
        ArrayList<Transfer> items = new ArrayList<Transfer>();
        for (AffectedStoreRecord asr : record) {
            StoreKey sk = asr.getKey();
            this.addTransfers(asr.getUploadedPaths(), sk, items, id, seenPaths);
            this.addTransfers(asr.getDownloadedPaths(), sk, items, id, seenPaths);
        }
        this.logger.debug("Retrieved {} files. Creating zip.", (Object)items.size());
        Collections.sort(items, (f, s) -> f.getPath().compareTo(s.getPath()));
        try (ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(file));){
            for (Transfer item : items) {
                if (item == null) continue;
                String path = item.getPath();
                ZipEntry ze = new ZipEntry(path);
                stream.putNextEntry(ze);
                InputStream itemStream = null;
                try {
                    itemStream = item.openInputStream();
                    IOUtils.copy((InputStream)itemStream, (OutputStream)stream);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)itemStream);
                }
            }
        }
        catch (IOException e) {
            throw new IndyWorkflowException("Failed to generate repository zip from tracking record: {}. Reason: {}", (Throwable)e, new Object[]{id, e.getMessage()});
        }
        return file;
    }

    private void addTransfers(Set<String> paths, StoreKey sk, List<Transfer> items, String trackingId, Set<String> seenPaths) throws IndyWorkflowException {
        if (paths != null) {
            for (String path : paths) {
                if (path == null || seenPaths.contains(path)) continue;
                Transfer transfer = this.contentManager.getTransfer(sk, path, TransferOperation.DOWNLOAD);
                if (transfer == null) {
                    Logger logger = LoggerFactory.getLogger(this.getClass());
                    logger.warn("While creating Folo repo zip for: {}, cannot find: {} in: {}", new Object[]{trackingId, path, sk});
                    continue;
                }
                seenPaths.add(path);
                items.add(transfer);
            }
        }
    }

    public TrackedContentDTO renderReport(String id, String apiBaseUrl) throws IndyWorkflowException {
        TrackingKey tk = new TrackingKey(id);
        this.logger.debug("Retrieving tracking record for: {}", (Object)tk);
        TrackedContentRecord record = this.recordManager.getIfExists(tk);
        this.logger.debug("Got: {}", (Object)record);
        if (record == null) {
            throw new IndyWorkflowException(ApplicationStatus.NOT_FOUND.code(), "No tracking record available for: %s", new Object[]{tk});
        }
        TreeSet<TrackedContentEntryDTO> uploads = new TreeSet<TrackedContentEntryDTO>();
        TreeSet<TrackedContentEntryDTO> downloads = new TreeSet<TrackedContentEntryDTO>();
        for (AffectedStoreRecord asr : record) {
            StoreKey sk = asr.getKey();
            Set paths = asr.getUploadedPaths();
            if (paths != null) {
                this.addEntries(uploads, sk, paths, apiBaseUrl);
            }
            if ((paths = asr.getDownloadedPaths()) == null) continue;
            this.addEntries(downloads, sk, paths, apiBaseUrl);
        }
        return new TrackedContentDTO(tk, uploads, downloads);
    }

    private void addEntries(Set<TrackedContentEntryDTO> entries, StoreKey key, Set<String> paths, String apiBaseUrl) throws IndyWorkflowException {
        for (String path : paths) {
            Transfer txfr = this.downloadManager.getStorageReference(key, new String[]{path});
            if (txfr == null) continue;
            TrackedContentEntryDTO entry = new TrackedContentEntryDTO(key, path);
            try {
                RemoteRepository repo;
                String localUrl = UrlUtils.buildUrl((String)apiBaseUrl, (String[])new String[]{key.getType().singularEndpointName(), key.getName(), path});
                String remoteUrl = null;
                if (StoreType.remote == key.getType() && (repo = this.storeManager.getRemoteRepository(key.getName())) != null) {
                    remoteUrl = UrlUtils.buildUrl((String)repo.getUrl(), (String[])new String[]{path});
                }
                entry.setLocalUrl(localUrl);
                entry.setOriginUrl(remoteUrl);
                Map digests = this.contentManager.digest(key, path, new ContentDigest[]{ContentDigest.MD5, ContentDigest.SHA_256});
                entry.setMd5((String)digests.get(ContentDigest.MD5));
                entry.setSha256((String)digests.get(ContentDigest.SHA_256));
                entries.add(entry);
            }
            catch (IndyDataException e) {
                throw new IndyWorkflowException("Cannot retrieve RemoteRepository: %s to calculate remote URL for: %s. Reason: %s", (Throwable)e, new Object[]{key, path, e.getMessage()});
            }
            catch (MalformedURLException e) {
                throw new IndyWorkflowException("Cannot format URL. Reason: %s", (Throwable)e, new Object[]{e.getMessage()});
            }
        }
    }

    public TrackedContentRecord getRecord(String id) throws IndyWorkflowException {
        TrackingKey tk = new TrackingKey(id);
        return this.recordManager.getIfExists(tk);
    }

    public void clearRecord(String id) {
        TrackingKey tk = new TrackingKey(id);
        this.recordManager.delete(tk);
    }

    public boolean hasRecord(String id) {
        return this.recordManager.hasRecord(new TrackingKey(id));
    }

    public void initRecord(String id) throws IndyWorkflowException {
        try {
            this.recordManager.getOrCreate(new TrackingKey(id));
        }
        catch (FoloContentException e) {
            throw new IndyWorkflowException("Failed to initialize tracking record for: %s. Reason: %s", (Throwable)e, new Object[]{id, e.getMessage()});
        }
    }
}

