/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.conf;

import java.io.File;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.commonjava.indy.conf.AbstractIndyConfigInfo;
import org.commonjava.indy.conf.AbstractIndyFeatureConfig;
import org.commonjava.indy.conf.IndyConfigClassInfo;
import org.commonjava.web.config.ConfigurationException;
import org.commonjava.web.config.annotation.ConfigName;
import org.commonjava.web.config.annotation.SectionName;

@SectionName(value="folo")
@Alternative
@Named
public class FoloConfig {
    public static final int DEFAULT_CACHE_TIMEOUT_SECONDS = 120;
    private Integer cacheTimeoutSeconds;

    public FoloConfig() {
    }

    public FoloConfig(Integer cacheTimeoutSeconds) {
        this.cacheTimeoutSeconds = cacheTimeoutSeconds;
    }

    public Integer getCacheTimeoutSeconds() {
        return this.cacheTimeoutSeconds == null ? 120 : this.cacheTimeoutSeconds;
    }

    @ConfigName(value="cache.timeout.seconds")
    public void setCacheTimeoutSeconds(Integer cacheTimeoutSeconds) {
        this.cacheTimeoutSeconds = cacheTimeoutSeconds;
    }

    @ApplicationScoped
    public static class FeatureConfig
    extends AbstractIndyFeatureConfig<FoloConfig, FoloConfig> {
        @Inject
        private ConfigInfo info;

        public FeatureConfig() {
            super(FoloConfig.class);
        }

        @Produces
        @Default
        @ApplicationScoped
        public FoloConfig getFlatFileConfig() throws ConfigurationException {
            return (FoloConfig)this.getConfig();
        }

        public IndyConfigClassInfo getInfo() {
            return this.info;
        }
    }

    @ApplicationScoped
    public static class ConfigInfo
    extends AbstractIndyConfigInfo {
        public ConfigInfo() {
            super(FoloConfig.class);
        }

        public String getDefaultConfigFileName() {
            return new File("conf.d", "folo.conf").getPath();
        }

        public InputStream getDefaultConfig() {
            return Thread.currentThread().getContextClassLoader().getResourceAsStream("default-folo.conf");
        }
    }
}

