/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs.impl;

import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.http.ServerWebSocket;
import org.vertx.java.core.http.impl.WebSocketMatcher;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.sockjs.SockJSSocket;
import org.vertx.java.core.sockjs.impl.SockJSSocketBase;
import org.vertx.java.core.sockjs.impl.WebSocketTransport;

class RawWebSocketTransport {
    private static final Logger log = LoggerFactory.getLogger(WebSocketTransport.class);

    RawWebSocketTransport(final Vertx vertx, WebSocketMatcher wsMatcher, RouteMatcher rm, String basePath, final Handler<SockJSSocket> sockHandler) {
        String wsRE = basePath + "/websocket";
        wsMatcher.addRegEx(wsRE, new Handler<WebSocketMatcher.Match>(){

            @Override
            public void handle(WebSocketMatcher.Match match) {
                RawWSSockJSSocket sock = new RawWSSockJSSocket(vertx, match.ws);
                sockHandler.handle(sock);
            }
        });
        rm.getWithRegEx(wsRE, new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest request) {
                request.response().setStatusCode(400);
                request.response().end("Can \"Upgrade\" only to \"WebSocket\".");
            }
        });
        rm.allWithRegEx(wsRE, new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest request) {
                request.response().headers().set("Allow", "GET");
                request.response().setStatusCode(405);
                request.response().end();
            }
        });
    }

    private static class RawWSSockJSSocket
    extends SockJSSocketBase {
        private ServerWebSocket ws;

        RawWSSockJSSocket(Vertx vertx, ServerWebSocket ws) {
            super(vertx);
            this.ws = ws;
        }

        @Override
        public SockJSSocket dataHandler(Handler<Buffer> handler) {
            this.ws.dataHandler(handler);
            return this;
        }

        @Override
        public SockJSSocket pause() {
            this.ws.pause();
            return this;
        }

        @Override
        public SockJSSocket resume() {
            this.ws.resume();
            return this;
        }

        @Override
        public SockJSSocket write(Buffer data) {
            this.ws.write(data);
            return this;
        }

        @Override
        public SockJSSocket setWriteQueueMaxSize(int maxQueueSize) {
            this.ws.setWriteQueueMaxSize(maxQueueSize);
            return this;
        }

        @Override
        public boolean writeQueueFull() {
            return this.ws.writeQueueFull();
        }

        @Override
        public SockJSSocket drainHandler(Handler<Void> handler) {
            this.ws.drainHandler(handler);
            return this;
        }

        @Override
        public SockJSSocket exceptionHandler(Handler<Throwable> handler) {
            this.ws.exceptionHandler(handler);
            return this;
        }

        @Override
        public SockJSSocket endHandler(Handler<Void> endHandler) {
            this.ws.endHandler(endHandler);
            return this;
        }

        @Override
        public void close() {
            super.close();
            this.ws.close();
        }
    }
}

