/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.web.config.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public final class ConfigFileUtils {
    private static final String LS = System.getProperty("line.separator", "\n");
    private static final String INCLUDE_COMMAND = "Include ";
    private static final String GLOB_BASE_PATTERN = "([^\\?\\*]+)[\\\\\\/]([\\*\\?]+.+)";
    private static final String GLOB_IDENTIFYING_PATTERN = ".*[\\?\\*].*";

    private ConfigFileUtils() {
    }

    public static InputStream readFileWithIncludes(String path) throws IOException {
        return ConfigFileUtils.readFileWithIncludes(new File(path));
    }

    public static InputStream readFileWithIncludes(File f) throws IOException {
        List<String> lines = ConfigFileUtils.readLinesWithIncludes(f);
        return new ByteArrayInputStream(StringUtils.join(lines, LS).getBytes());
    }

    public static List<String> readLinesWithIncludes(File f) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        List<String> lines = FileUtils.readLines(f);
        File dir = f.getParentFile();
        for (String line : lines) {
            if (line.startsWith(INCLUDE_COMMAND)) {
                String glob = line.substring(INCLUDE_COMMAND.length());
                for (File file : ConfigFileUtils.findMatching(dir, glob)) {
                    result.addAll(ConfigFileUtils.readLinesWithIncludes(file));
                }
                continue;
            }
            result.add(line);
        }
        return result;
    }

    public static File[] findMatching(File dir, String glob) throws IOException {
        if (!glob.matches(GLOB_IDENTIFYING_PATTERN)) {
            File f = new File(glob);
            if (!f.isAbsolute()) {
                f = new File(dir, glob);
            }
            return new File[]{f};
        }
        Matcher m = Pattern.compile(GLOB_BASE_PATTERN).matcher(glob);
        String base = null;
        String pattern = null;
        if (m.matches()) {
            base = m.group(1);
            pattern = m.group(2);
            if (!new File(base).isAbsolute()) {
                base = new File(dir, base).getAbsolutePath();
            }
        } else {
            base = dir.getAbsolutePath();
            pattern = glob;
        }
        if (pattern.length() < 1) {
            return new File[]{new File(base).getCanonicalFile()};
        }
        StringBuilder regex = new StringBuilder();
        block5: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '*') {
                        regex.append(".+");
                        ++i;
                        continue block5;
                    }
                    regex.append("[^\\\\\\/]*");
                    continue block5;
                }
                case '.': {
                    regex.append("\\.");
                    continue block5;
                }
                case '?': {
                    regex.append(".");
                    continue block5;
                }
                default: {
                    regex.append(c);
                }
            }
        }
        boolean dirsOnly = pattern.endsWith("/") || pattern.endsWith("\\");
        String globRegex = regex.toString();
        File bdir = new File(base).getCanonicalFile();
        int bdirLen = bdir.getPath().length() + 1;
        List<File> allFiles = ConfigFileUtils.listRecursively(bdir);
        Iterator<File> it = allFiles.iterator();
        while (it.hasNext()) {
            File f = it.next();
            if (dirsOnly && !f.isDirectory()) {
                it.remove();
                continue;
            }
            String sub = f.getAbsolutePath().substring(bdirLen);
            if (sub.matches(globRegex)) continue;
            it.remove();
        }
        return allFiles.toArray(new File[0]);
    }

    private static List<File> listRecursively(File dir) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File d = dir.getCanonicalFile();
        ConfigFileUtils.recurse(d, files);
        return files;
    }

    private static void recurse(File dir, List<File> files) throws IOException {
        if (!dir.isDirectory()) {
            return;
        }
        for (String name : dir.list()) {
            File f = new File(dir, name).getCanonicalFile();
            files.add(f);
            if (!f.isDirectory()) continue;
            ConfigFileUtils.recurse(f, files);
        }
    }
}

