/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.web.config.dotconf;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.commonjava.web.config.ConfigurationException;
import org.commonjava.web.config.ConfigurationListener;
import org.commonjava.web.config.ConfigurationReader;
import org.commonjava.web.config.ConfigurationRegistry;
import org.commonjava.web.config.DefaultConfigurationListener;
import org.commonjava.web.config.DefaultConfigurationRegistry;
import org.commonjava.web.config.section.ConfigurationSectionListener;

public class DotConfConfigurationReader
implements ConfigurationReader {
    private final ConfigurationRegistry dispatch;
    private final Pattern parameter;

    @Inject
    public DotConfConfigurationReader(ConfigurationRegistry dispatch) {
        this.dispatch = dispatch;
        this.parameter = Pattern.compile("\\s*([-._a-zA-Z0-9]+)\\s*[:=]\\s*([^\\s#]+)(\\s*#.*)?");
    }

    public DotConfConfigurationReader(Class<?> ... types) throws ConfigurationException {
        this(new DefaultConfigurationRegistry(new DefaultConfigurationListener(types)));
    }

    public DotConfConfigurationReader(ConfigurationSectionListener<?> ... sectionListeners) throws ConfigurationException {
        this(new DefaultConfigurationRegistry(new DefaultConfigurationListener(sectionListeners)));
    }

    public DotConfConfigurationReader(ConfigurationListener ... listeners) throws ConfigurationException {
        this(new DefaultConfigurationRegistry(listeners));
    }

    public DotConfConfigurationReader(Object ... data) throws ConfigurationException {
        this(new DefaultConfigurationRegistry(data));
    }

    @Override
    public void loadConfiguration(InputStream stream) throws ConfigurationException {
        List<String> lines;
        try {
            lines = IOUtils.readLines(stream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to read configuration. Error: %s", (Throwable)e, e.getMessage());
        }
        String sectionName = "default";
        boolean processSection = this.dispatch.sectionStarted(sectionName);
        for (String line : lines) {
            Matcher matcher;
            String trimmed = line.trim();
            if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
                if (trimmed.length() == 2) continue;
                this.dispatch.sectionComplete(sectionName);
                sectionName = trimmed.substring(1, trimmed.length() - 1);
                processSection = this.dispatch.sectionStarted(sectionName);
                continue;
            }
            if (!processSection || !(matcher = this.parameter.matcher(line)).matches()) continue;
            String key = matcher.group(1);
            String value = matcher.group(2);
            this.dispatch.parameter(sectionName, key, value);
        }
        this.dispatch.sectionComplete(sectionName);
        this.dispatch.configurationParsed();
    }
}

