/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.vertx.vabr;

import org.commonjava.vertx.vabr.ApplicationRouter;
import org.commonjava.vertx.vabr.Method;
import org.vertx.java.core.http.HttpServerRequest;

public abstract class RouteBinding {
    public static final String RECOMMENDED_CONTENT_TYPE = "Recommended-Content-Type";
    private final String path;
    private final Method method;
    private final String contentType;

    protected RouteBinding(String path, Method method, String contentType) {
        this.path = path;
        this.method = method;
        this.contentType = contentType.length() < 1 ? null : contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getPath() {
        return this.path;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return "Route [" + this.method.name() + " " + this.path + "]";
    }

    public void handle(ApplicationRouter router, HttpServerRequest req) throws Exception {
        if (this.contentType != null) {
            req.headers().add(RECOMMENDED_CONTENT_TYPE, this.contentType);
        }
        this.dispatch(router, req);
    }

    protected abstract void dispatch(ApplicationRouter var1, HttpServerRequest var2) throws Exception;
}

