/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.rest;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.commonjava.freeki.conf.FreekiConfig;
import org.commonjava.freeki.data.FreekiStore;
import org.commonjava.freeki.rest.PathParameter;
import org.commonjava.util.logging.Logger;
import org.commonjava.vertx.vabr.Method;
import org.commonjava.vertx.vabr.RouteHandler;
import org.commonjava.vertx.vabr.anno.Route;
import org.commonjava.vertx.vabr.anno.Routes;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.impl.DefaultVertx;

public class ExportContentHandler
implements RouteHandler {
    private final Logger logger = new Logger(this.getClass());
    private final Map<String, File> exports = new ConcurrentHashMap<String, File>();
    private final Map<String, Exporter> exporters = new ConcurrentHashMap<String, Exporter>();
    private final Set<String> downloadingPaths = new HashSet<String>();
    private final ExecutorService executor = Executors.newFixedThreadPool(12, new ThreadFactory(){
        private int counter = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("export-" + this.counter++);
            t.setPriority(7);
            t.setDaemon(true);
            return t;
        }
    });
    private final Vertx vertx = new DefaultVertx();
    private final FreekiConfig config;
    private final FreekiStore store;

    public ExportContentHandler(FreekiConfig config, FreekiStore store) {
        this.config = config;
        this.store = store;
    }

    @Routes(value={@Route(path="/export/zip", method=Method.GET), @Route(path="/export/zip/:path=(.+)", method=Method.GET)})
    public void zip(final HttpServerRequest req) throws Exception {
        req.endHandler(new Handler<Void>(){

            @Override
            public void handle(Void event) {
                String path = req.params().get(PathParameter.PATH.param());
                File exported = (File)ExportContentHandler.this.exports.get(path);
                if (exported != null) {
                    req.response().headers().add("Content-Type", "application/zip");
                    req.response().setStatusMessage("OK").setStatusCode(200).sendFile(exported.getAbsolutePath()).end();
                    return;
                }
                Exporter exporter = (Exporter)ExportContentHandler.this.exporters.get(path);
                if (exporter == null) {
                    String seedUrl;
                    try {
                        seedUrl = req.absoluteURI().toURL().toExternalForm().replace("/export/zip", "/wiki");
                    }
                    catch (MalformedURLException e) {
                        ExportContentHandler.this.logger.error("Cannot format target URL from: %s. Reason: %s", e, req.absoluteURI(), e.getMessage());
                        req.response().setStatusCode(500).setStatusMessage("Error while exporting content").setChunked(true).write(e.getMessage()).end();
                        return;
                    }
                    exporter = new Exporter(path, seedUrl, ExportContentHandler.this.exporters, ExportContentHandler.this.exports, ExportContentHandler.this.config.getExportsDir(), ExportContentHandler.this.store, ExportContentHandler.this.vertx, ExportContentHandler.this.executor, ExportContentHandler.this.downloadingPaths);
                    ExportContentHandler.this.executor.execute(exporter);
                    ExportContentHandler.this.exporters.put(path, exporter);
                }
                if (exporter.hasError()) {
                    req.response().setStatusCode(500).setStatusMessage("Error while exporting content").setChunked(true).write(exporter.getError().getMessage()).end();
                    return;
                }
                if (!exporter.isFinished()) {
                    req.response().headers().add("Refresh", "5;" + req.absoluteURI());
                    req.response().setStatusCode(202).setStatusMessage("Export is running").end();
                    return;
                }
                req.response().setChunked(true).setStatusCode(500).setStatusMessage("Unknown export error").write("Exporter is present and marked as finished without error, but has not contributed exported content. Please try again.").end();
            }
        });
    }

    public static final class ExportCrawler
    implements Runnable {
        private final Logger logger = new Logger(this.getClass());
        private final ExportCommunications ed;
        private Thread myThread;
        private boolean stop;

        public ExportCrawler(ExportCommunications ed) {
            this.ed = ed;
        }

        public void stop() {
            this.stop = true;
            this.myThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.myThread = Thread.currentThread();
            while (!this.stop) {
                URL url;
                LinkedList<URL> linkedList = this.ed.todo;
                synchronized (linkedList) {
                    while (this.ed.todo.isEmpty()) {
                        try {
                            this.ed.todo.wait(500L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    url = this.ed.todo.removeFirst();
                }
                if (!this.shouldVisit(url)) continue;
                this.visit(url);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldVisit(URL url) {
            this.logger.info("Checking: %s\nVs: %s", url, this.ed.seedUrl);
            boolean relevantWikiPath = url.toExternalForm().startsWith(this.ed.seedUrl.toExternalForm());
            String seedDomain = this.toDomain(this.ed.seedUrl);
            String domain = this.toDomain(url);
            boolean domainMatches = domain.equals(seedDomain);
            boolean staticUrl = url.getPath().startsWith("/static/");
            this.logger.info("Relevant wiki path? %s\nDomain matches ('%s' vs. '%s')? %s\nStatic URL? %s", relevantWikiPath, domain, seedDomain, domainMatches, staticUrl);
            if (relevantWikiPath || domainMatches && staticUrl) {
                boolean downloading;
                Set<String> set = this.ed.localDownloadingPaths;
                synchronized (set) {
                    downloading = this.ed.localDownloadingPaths.contains(url.getPath());
                    this.logger.info("Already downloading in another (local) crawler thread? %s", downloading);
                    if (downloading) {
                        return false;
                    }
                    this.ed.localDownloadingPaths.add(url.getPath());
                    this.ed.localDownloadingPaths.notifyAll();
                }
                set = this.ed.downloadingPaths;
                synchronized (set) {
                    downloading = this.ed.downloadingPaths.contains(url.getPath());
                    this.logger.info("Already downloading in another crawler thread? %s", downloading);
                    if (downloading) {
                        return false;
                    }
                    this.ed.downloadingPaths.add(url.getPath());
                    this.ed.downloadingPaths.notifyAll();
                    return true;
                }
            }
            return false;
        }

        private String toDomain(URL url) {
            String domain = url.getHost();
            if (url.getPort() > 0) {
                domain = domain + ":" + url.getPort();
            }
            return domain;
        }

        public void visit(final URL pageUrl) {
            int port = pageUrl.getPort();
            if (port < 1) {
                port = pageUrl.getProtocol().equals("https") ? 443 : 80;
            }
            HttpClient client = (HttpClient)((HttpClient)this.ed.vertx.createHttpClient().setHost(pageUrl.getHost()).setPort(port).setReuseAddress(true)).setSSL(pageUrl.getProtocol().equals("https"));
            client.get(pageUrl.toExternalForm(), new Handler<HttpClientResponse>(){

                @Override
                public void handle(HttpClientResponse resp) {
                    resp.bodyHandler(new Handler<Buffer>(){

                        @Override
                        public void handle(Buffer data) {
                            ExportCrawler.this.logger.info("Visiting: %s", pageUrl);
                            String path = pageUrl.getPath();
                            if (((ExportCrawler)ExportCrawler.this).ed.store.hasGroup(path)) {
                                path = new File(path, "index.html").getPath();
                            } else if (path.indexOf(46, path.lastIndexOf(47)) < 0) {
                                path = path + ".html";
                            }
                            File f = new File(((ExportCrawler)ExportCrawler.this).ed.exportBasedir, path);
                            File d = f.getParentFile();
                            if (!d.isDirectory() && !d.mkdirs()) {
                                ExportCrawler.this.logger.error("Failed to create export directory: %s", d);
                                ((ExportCrawler)ExportCrawler.this).ed.errors.put(path, new Exception("Failed to create export sub-directory: " + d));
                            }
                            HashSet<URL> newUrls = new HashSet<URL>();
                            try {
                                if (path.endsWith(".html")) {
                                    Document doc = Jsoup.parse(new String(data.getBytes()), pageUrl.toExternalForm());
                                    for (Element link : doc.select("a[href]")) {
                                        this.cleanLink(link, "abs:href", path, newUrls);
                                    }
                                    for (Element link : doc.select("link[href]")) {
                                        this.cleanLink(link, "abs:href", path, newUrls);
                                    }
                                    for (Element link : doc.select("[src]")) {
                                        this.cleanLink(link, "abs:src", path, newUrls);
                                    }
                                    FileUtils.writeStringToFile(f, doc.outerHtml());
                                } else if (path.endsWith(".css")) {
                                    String css = new String(data.getBytes());
                                    Matcher matcher = Pattern.compile("(url\\()(.+)(\\);)").matcher(css);
                                    int start = 0;
                                    StringBuilder sb = new StringBuilder();
                                    while (matcher.find(start)) {
                                        String url = matcher.group(2);
                                        if (sb.length() < 1 && matcher.start() > 0) {
                                            sb.append(css.substring(0, matcher.start()));
                                        }
                                        sb.append(matcher.group(1));
                                        sb.append(this.cleanUrl(url, path, newUrls));
                                        sb.append(matcher.group(3));
                                        start = matcher.end();
                                    }
                                    if (start < css.length() - 1) {
                                        sb.append(css.substring(start));
                                    }
                                    FileUtils.writeStringToFile(f, sb.toString());
                                } else {
                                    FileUtils.writeByteArrayToFile(f, data.getBytes());
                                }
                            }
                            catch (IOException e) {
                                ExportCrawler.this.logger.error("Error storing: %s. Reason: %s", e, f, e.getMessage());
                                ((ExportCrawler)ExportCrawler.this).ed.errors.put(path, e);
                            }
                        }

                        private void cleanLink(Element link, String attr, String path, Set<URL> newUrls) throws MalformedURLException {
                            String url = link.attr(attr);
                            String relative = this.cleanUrl(url, path, newUrls);
                            if (!relative.equals(url)) {
                                link.attr(attr, url);
                            }
                        }

                        private String cleanUrl(String url, String path, Set<URL> newUrls) throws MalformedURLException {
                            if (url.startsWith("/")) {
                                url = this.relativize(url, path);
                                newUrls.add(this.relativeUrl(pageUrl, url));
                            } else if (url.matches("http[s]?://.+")) {
                                newUrls.add(new URL(url));
                            } else {
                                newUrls.add(this.relativeUrl(pageUrl, "../" + url));
                            }
                            return url;
                        }

                        private URL relativeUrl(URL pageUrl, String url) throws MalformedURLException {
                            String[] parts = (pageUrl.toExternalForm() + url).split("/");
                            LinkedList<String> clean = new LinkedList<String>();
                            for (String part : parts) {
                                if (part.equals("..") && !clean.isEmpty()) {
                                    clean.removeLast();
                                    continue;
                                }
                                clean.add(part);
                            }
                            return new URL(StringUtils.join(clean, "/"));
                        }

                        private String relativize(String url, String path) {
                            for (int i = 0; i < path.split("/").length; ++i) {
                                url = "../" + url;
                            }
                            return url;
                        }
                    });
                }
            });
        }
    }

    public static final class ExportCommunications {
        public final File exportBasedir;
        public final URL seedUrl;
        public final String pathBase;
        public final Set<String> downloadingPaths;
        public final Map<String, Throwable> errors = new HashMap<String, Throwable>();
        public final FreekiStore store;
        public final Set<String> localDownloadingPaths;
        public final LinkedList<URL> todo;
        public final Vertx vertx;

        public ExportCommunications(LinkedList<URL> todo, File exportBasedir, URL seedUrl, String pathBase, FreekiStore store, Vertx vertx, Set<String> downloadingPaths, Set<String> localDownloadingPaths) {
            this.todo = todo;
            this.exportBasedir = exportBasedir;
            this.seedUrl = seedUrl;
            this.pathBase = pathBase;
            this.store = store;
            this.vertx = vertx;
            this.downloadingPaths = downloadingPaths;
            this.localDownloadingPaths = localDownloadingPaths;
        }
    }

    public static final class Exporter
    implements Runnable {
        private final Logger logger = new Logger(this.getClass());
        private final Map<String, Exporter> exporters;
        private final String myBasePath;
        private final Map<String, File> exported;
        private final File exportsBasedir;
        private final Set<String> downloadingPaths;
        private final Set<String> localDownloadingPaths = new HashSet<String>();
        private Throwable error;
        private boolean finished;
        private final String seed;
        private ExportCommunications comms;
        private final FreekiStore store;
        private final ExecutorService executor;
        private final Vertx vertx;

        public Exporter(String myBasePath, String seedUrl, Map<String, Exporter> exporters, Map<String, File> exported, File exportsBasedir, FreekiStore store, Vertx vertx, ExecutorService executor, Set<String> downloadingPaths) {
            this.myBasePath = myBasePath;
            this.seed = seedUrl;
            this.exporters = exporters;
            this.exported = exported;
            this.exportsBasedir = exportsBasedir;
            this.store = store;
            this.vertx = vertx;
            this.executor = executor;
            this.downloadingPaths = downloadingPaths;
        }

        public Throwable getError() {
            if (this.error != null) {
                return this.error;
            }
            if (this.comms != null && !this.comms.errors.isEmpty()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                int idx = 0;
                for (Map.Entry<String, Throwable> entry : this.comms.errors.entrySet()) {
                    String path = entry.getKey();
                    Throwable error = entry.getValue();
                    pw.printf("%d. For path: '%s'\n\n", idx++, path);
                    error.printStackTrace(pw);
                    pw.println();
                    pw.println();
                }
                this.error = new Exception(sw.toString());
                return this.error;
            }
            return null;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean hasError() {
            return this.error != null || this.comms != null && !this.comms.errors.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    URL seedUrl = new URL(this.seed);
                    LinkedList<URL> todo = new LinkedList<URL>();
                    todo.add(seedUrl);
                    this.comms = new ExportCommunications(todo, this.exportsBasedir, seedUrl, this.myBasePath, this.store, this.vertx, this.downloadingPaths, this.localDownloadingPaths);
                    for (int i = 0; i < 4; ++i) {
                        this.executor.execute(new ExportCrawler(this.comms));
                    }
                    this.exported.put(this.myBasePath, new File(this.exportsBasedir, this.myBasePath));
                    this.exporters.remove(this.myBasePath);
                }
                catch (MalformedURLException e) {
                    this.logger.error("Cannot format target URL from: %s. Reason: %s", e, this.seed, e.getMessage());
                    this.error = e;
                    Set<String> set = this.downloadingPaths;
                    synchronized (set) {
                        this.downloadingPaths.removeAll(this.localDownloadingPaths);
                        this.downloadingPaths.notifyAll();
                    }
                    return;
                }
            }
            finally {
                Set<String> set = this.downloadingPaths;
                synchronized (set) {
                    this.downloadingPaths.removeAll(this.localDownloadingPaths);
                    this.downloadingPaths.notifyAll();
                }
            }
        }
    }
}

