/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.cli;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import org.commonjava.freeki.cli.Main;
import org.commonjava.freeki.cli.MessageConsole;
import org.eclipse.jgit.api.errors.GitAPIException;

public class WebstartMain {
    public static void main(final String[] args) throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("Starting web frame");
                    new ConsoleFrame(args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static final class ConsoleFrame
    extends JFrame {
        private static final long serialVersionUID = 1L;
        private final JTextPane pane = new JTextPane();
        private final JScrollPane scrollPane = new JScrollPane(this.pane);
        private final JPanel panel = new JPanel();
        private final Main main;

        ConsoleFrame(String[] args) throws Exception {
            this.setDefaultCloseOperation(3);
            this.setBounds(100, 100, 950, 600);
            this.panel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.panel.setLayout(new BorderLayout(0, 0));
            this.setContentPane(this.panel);
            this.pane.setEditable(false);
            this.pane.setContentType("text/html");
            this.pane.setText("");
            this.panel.add((Component)this.scrollPane, "Center");
            MessageConsole console = new MessageConsole(this.pane);
            console.redirectErr(Color.red, System.err);
            console.redirectOut(Color.black, System.out);
            console.setMessageLines(5000);
            this.setVisible(true);
            this.main = new Main(args);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConsoleFrame.this.main.run();
                    }
                    catch (IOException | GitAPIException e) {
                        e.printStackTrace();
                        ConsoleFrame.this.main.stop();
                    }
                    System.out.println("Wiki STOPPED");
                }
            }).start();
        }
    }
}

