/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

class FlagMarkingGenerator
implements RuleMethodProcessor {
    FlagMarkingGenerator() {
    }

    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        return ruleMethod.hasSuppressNodeAnnotation() || ruleMethod.hasSuppressSubnodesAnnotation() || ruleMethod.hasSkipNodeAnnotation() || ruleMethod.hasMemoMismatchesAnnotation();
    }

    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) throws Exception {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        Preconditions.checkState(!ruleMethod.isSuperMethod());
        InsnList insnList = ruleMethod.instructions;
        AbstractInsnNode abstractInsnNode = insnList.getLast();
        while (abstractInsnNode.getOpcode() != 176) {
            abstractInsnNode = abstractInsnNode.getPrevious();
        }
        insnList.insertBefore(abstractInsnNode, new InsnNode(89));
        LabelNode labelNode = new LabelNode();
        insnList.insertBefore(abstractInsnNode, new JumpInsnNode(198, labelNode));
        if (ruleMethod.hasSuppressNodeAnnotation()) {
            this.generateMarkerCall(insnList, abstractInsnNode, "suppressNode");
        }
        if (ruleMethod.hasSuppressSubnodesAnnotation()) {
            this.generateMarkerCall(insnList, abstractInsnNode, "suppressSubnodes");
        }
        if (ruleMethod.hasSkipNodeAnnotation()) {
            this.generateMarkerCall(insnList, abstractInsnNode, "skipNode");
        }
        if (ruleMethod.hasMemoMismatchesAnnotation()) {
            this.generateMarkerCall(insnList, abstractInsnNode, "memoMismatches");
        }
        insnList.insertBefore(abstractInsnNode, labelNode);
    }

    private void generateMarkerCall(InsnList insnList, AbstractInsnNode abstractInsnNode, String string) {
        insnList.insertBefore(abstractInsnNode, new MethodInsnNode(185, Types.RULE.getInternalName(), string, "()" + Types.RULE.getDescriptor()));
    }
}

