/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.web.config.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.inject.Named;
import org.commonjava.web.config.ConfigurationException;
import org.commonjava.web.config.ConfigurationReader;
import org.commonjava.web.config.ConfigurationRegistry;
import org.commonjava.web.config.DefaultConfigurationRegistry;
import org.commonjava.web.config.section.ConfigurationSectionListener;

@Named(value="single-section")
public class SingleSectionConfigReader
implements ConfigurationReader {
    private final ConfigurationRegistry dispatch;

    public SingleSectionConfigReader(ConfigurationSectionListener<?> listener) throws ConfigurationException {
        this.dispatch = new DefaultConfigurationRegistry(listener);
    }

    public SingleSectionConfigReader(Object target) throws ConfigurationException {
        this.dispatch = new DefaultConfigurationRegistry(target);
    }

    @Override
    public void loadConfiguration(InputStream stream) throws ConfigurationException {
        Properties props = new Properties();
        try {
            props.load(stream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to read configuration. Error: %s", (Throwable)e, e.getMessage());
        }
        if (!this.dispatch.sectionStarted("default")) {
            return;
        }
        for (Object k : props.keySet()) {
            String key = (String)k;
            this.dispatch.parameter("default", key, props.getProperty(key));
        }
        this.dispatch.sectionComplete("default");
        this.dispatch.configurationParsed();
    }
}

