/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.rest;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.commonjava.freeki.data.FreekiStore;
import org.commonjava.freeki.infra.auth.Authorizer;
import org.commonjava.freeki.infra.render.RenderingEngine;
import org.commonjava.freeki.infra.render.RenderingException;
import org.commonjava.freeki.infra.route.Method;
import org.commonjava.freeki.infra.route.RouteHandler;
import org.commonjava.freeki.infra.route.anno.Route;
import org.commonjava.freeki.infra.route.anno.Routes;
import org.commonjava.freeki.model.Page;
import org.commonjava.freeki.rest.PathParameter;
import org.commonjava.freeki.util.ContentType;
import org.commonjava.freeki.util.RequestUtils;
import org.commonjava.mimeparse.MIMEParse;
import org.commonjava.util.logging.Logger;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;

public class PageContentHandler
implements RouteHandler {
    private static final Set<String> PAGE_ACCEPT = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(ContentType.TEXT_HTML.value());
            this.add(ContentType.TEXT_PLAIN.value());
            this.add(ContentType.APPLICATION_JSON.value());
        }
    };
    private final FreekiStore store;
    private final RenderingEngine engine;
    private final Logger logger = new Logger(this.getClass());
    private final Authorizer auth;

    public PageContentHandler(FreekiStore store, RenderingEngine engine, Authorizer authorizer) {
        this.store = store;
        this.engine = engine;
        this.auth = authorizer;
    }

    @Routes(value={@Route(path="/api/page/:dir=(.*)/:page", method=Method.DELETE)})
    public void delete(HttpServerRequest req) throws Exception {
        if (this.auth.checkReadOnly(req)) {
            return;
        }
        String dir = req.params().get(PathParameter.DIR.param());
        String page = req.params().get(PathParameter.PAGE.param());
        if (dir == null) {
            dir = "/";
        }
        if (!this.store.hasPage(dir, page)) {
            req.response().setStatusCode(404).setStatusMessage("Not found").end();
            return;
        }
        boolean success = this.store.deletePage(dir, page);
        if (success) {
            req.response().setStatusCode(200).setStatusMessage("Deleted").end();
        } else {
            req.response().setStatusCode(417).setStatusMessage("Delete failed").end();
        }
    }

    @Routes(value={@Route(path="/api/page/:page", method=Method.PUT, contentType="text/plain"), @Route(path="/api/page/:page", method=Method.POST, contentType="text/plain"), @Route(path="/api/page/:dir=(.*/)?:page", method=Method.PUT, contentType="text/plain"), @Route(path="/api/page/:dir=(.*/)?:page", method=Method.POST, contentType="text/plain")})
    public void store(final HttpServerRequest req) throws Exception {
        if (this.auth.checkReadOnly(req)) {
            return;
        }
        String dir = req.params().get(PathParameter.DIR.param());
        final String page = req.params().get(PathParameter.PAGE.param());
        if (dir == null) {
            dir = "/";
        }
        final String group = dir;
        req.bodyHandler(new Handler<Buffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Buffer event) {
                block13: {
                    String content = event.getString(0, event.length());
                    try {
                        Page pageObj;
                        String title = page;
                        boolean titleParsed = false;
                        BufferedReader reader = new BufferedReader(new StringReader(content.toString()));
                        String firstLine = null;
                        while ((firstLine = reader.readLine()).trim().length() < 1) {
                        }
                        if (firstLine != null && firstLine.length() > 0) {
                            if (firstLine.startsWith("# ")) {
                                title = firstLine.substring(2);
                                titleParsed = true;
                            } else {
                                String secondLine = reader.readLine();
                                if (secondLine != null && secondLine.matches("[=]+")) {
                                    title = firstLine;
                                    titleParsed = true;
                                }
                            }
                        }
                        if ((pageObj = PageContentHandler.this.store.getPage(group, page)) == null) {
                            pageObj = new Page(group, Page.serverPathFor(group, page), content.toString(), title, System.currentTimeMillis(), "unknown");
                        } else {
                            pageObj.setContent(content.toString());
                            pageObj.setUpdated(new Date());
                            if (titleParsed) {
                                pageObj.setTitle(title);
                            }
                        }
                        String location = "/wiki/" + pageObj.getId();
                        if (PageContentHandler.this.store.storePage(pageObj)) {
                            req.response().putHeader("Location", location).setStatusCode(201).setStatusMessage("Created: " + page).end();
                            break block13;
                        }
                        req.response().putHeader("Location", location).setStatusCode(200).setStatusMessage("Stored updates to: " + page).end();
                    }
                    catch (Exception e) {
                        PageContentHandler.this.logger.error(e.getMessage(), e, new Object[0]);
                        req.response().setStatusCode(500).setStatusMessage(e.getMessage()).end(e.getMessage());
                    }
                }
            }
        });
    }

    @Routes(value={@Route(path="/wiki/:page", method=Method.GET), @Route(path="/wiki/:dir=(.*)/:page", method=Method.GET), @Route(path="/api/page/:page", method=Method.GET, contentType="text/plain"), @Route(path="/api/page/:dir=(.*)/:page", method=Method.GET, contentType="text/plain")})
    public void get(HttpServerRequest req) throws Exception {
        String mimeAccept;
        req.response().setChunked(true);
        req.response().setStatusCode(200);
        String dir = req.params().get(PathParameter.DIR.param());
        String page = req.params().get(PathParameter.PAGE.param());
        if (dir == null) {
            dir = "/";
        }
        if ((mimeAccept = req.headers().get("Recommended-Content-Type")) == null) {
            String acceptHeader = req.headers().get("Accept");
            mimeAccept = MIMEParse.bestMatch(PAGE_ACCEPT, acceptHeader);
        }
        ContentType type = ContentType.find(mimeAccept);
        try {
            Map<String, String> queryParams;
            Page pg = this.store.getPage(dir, page);
            if (pg == null) {
                req.response().setStatusCode(404).setStatusMessage("Not found.").end();
                return;
            }
            if (req.query() != null) {
                QueryStringDecoder qsd = new QueryStringDecoder(req.query(), false);
                queryParams = RequestUtils.toMap(qsd.parameters());
            } else {
                queryParams = Collections.emptyMap();
            }
            String rendered = this.engine.render(pg, type, queryParams);
            if (type != null) {
                req.response().headers().add("Content-Type", type.value());
            }
            if (rendered != null) {
                req.response().end(rendered);
            } else {
                req.response().setStatusCode(500).setStatusMessage("Rendered page has no content.").end();
            }
        }
        catch (IOException | RenderingException e) {
            this.logger.error("Failed to retrieve group: %s. Reason: %s", e, dir, e.getMessage());
            throw e;
        }
    }
}

