/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.render.app.humanoid;

import com.jme3.asset.AssetManager;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.jme3.util.SkyFactory;
import java.util.Map;
import java.util.concurrent.Callable;
import org.appdapter.core.name.Ident;
import org.appdapter.fancy.rclient.RepoClient;
import org.cogchar.api.cinema.AnimWaypointsConfig;
import org.cogchar.api.cinema.LightsCameraConfig;
import org.cogchar.api.cinema.PathConfig;
import org.cogchar.api.cinema.SpatialActionSetConfig;
import org.cogchar.api.cinema.ThingAnimConfig;
import org.cogchar.render.app.core.WorkaroundAppStub;
import org.cogchar.render.app.entity.VWorldEntity;
import org.cogchar.render.app.entity.VWorldEntityActionConsumer;
import org.cogchar.render.app.humanoid.HumanoidRenderContext;
import org.cogchar.render.model.humanoid.HumanoidFigure;
import org.cogchar.render.model.humanoid.VWorldHumanoidFigureEntity;
import org.cogchar.render.opengl.optic.CameraMgr;
import org.cogchar.render.opengl.optic.LightFactory;
import org.cogchar.render.scene.goody.PathMgr;
import org.cogchar.render.scene.goody.SpatialAnimMgr;
import org.cogchar.render.sys.context.CogcharRenderContext;
import org.cogchar.render.sys.goody.GoodyRenderRegistryClient;
import org.cogchar.render.sys.registry.RenderRegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanoidRenderWorldMapper {
    private static Logger theLogger = LoggerFactory.getLogger(HumanoidRenderWorldMapper.class);

    public void initLightsAndCamera(RepoClient qi, HumanoidRenderContext hrc, Ident qGraph) {
        LightsCameraConfig lcc = new LightsCameraConfig(qi, qGraph);
        RenderRegistryClient rendRegCli = hrc.getRenderRegistryClient();
        CameraMgr cm = rendRegCli.getOpticCameraFacade(null);
        cm.initCamerasFromConfig(lcc, rendRegCli);
        LightFactory lf = rendRegCli.getOpticLightFacade(null);
        lf.initLightsFromConfig(lcc, (CogcharRenderContext)hrc);
        this.setBackgroundColor(hrc, lcc);
        this.setSkyBox(hrc);
    }

    private PathMgr getPathMgr(HumanoidRenderContext hrc) {
        return hrc.getGoodyRenderRegistryClient().getScenePathFacade(null);
    }

    private SpatialAnimMgr getSpatialAnimMgr(HumanoidRenderContext hrc) {
        return hrc.getGoodyRenderRegistryClient().getSceneAnimFacade(null);
    }

    public void initWaypoints(RepoClient qi, Ident qGraph) {
        AnimWaypointsConfig awc = new AnimWaypointsConfig(qi, qGraph);
        AnimWaypointsConfig.setMainConfig((AnimWaypointsConfig)awc);
    }

    public void initPaths(RepoClient qi, HumanoidRenderContext hrc, Ident qGraph) {
        PathConfig pc = new PathConfig(qi, qGraph);
        this.getPathMgr(hrc).storeAnimationsFromConfig((SpatialActionSetConfig)pc, (CogcharRenderContext)hrc);
    }

    public void initThingAnims(RepoClient qi, HumanoidRenderContext hrc, Ident qGraph) {
        ThingAnimConfig tac = new ThingAnimConfig(qi, qGraph);
        this.getSpatialAnimMgr(hrc).storeAnimationsFromConfig((SpatialActionSetConfig)tac, (CogcharRenderContext)hrc);
    }

    public void clearLights(HumanoidRenderContext hrc) {
        RenderRegistryClient rendRegCli = hrc.getRenderRegistryClient();
        LightFactory lf = rendRegCli.getOpticLightFacade(null);
        lf.clearLights((CogcharRenderContext)hrc);
    }

    public void clearCinematics(HumanoidRenderContext hrc) {
        this.getPathMgr(hrc).clearAnimations();
        this.getSpatialAnimMgr(hrc).clearAnimations();
    }

    public void clearViewPorts(HumanoidRenderContext hrc) {
        RenderRegistryClient rrc = hrc.getRenderRegistryClient();
        CameraMgr cm = rrc.getOpticCameraFacade(null);
        cm.clearViewPorts(rrc);
    }

    private void setBackgroundColor(HumanoidRenderContext hrc, LightsCameraConfig lcc) {
        ColorRGBA bgColor = new ColorRGBA(lcc.backgroundColor[0], lcc.backgroundColor[1], lcc.backgroundColor[2], lcc.backgroundColor[3]);
        WorkaroundAppStub stub = hrc.getAppStub();
        ViewPort vp = stub.getPrimaryAppViewPort();
        vp.setBackgroundColor(bgColor);
    }

    private void setSkyBox(final HumanoidRenderContext hrc) {
        hrc.getAppStub().enqueue(new Callable(){

            public Object call() {
                try {
                    Node root = hrc.getGoodyRenderRegistryClient().getJme3RootDeepNode(null);
                    AssetManager assetManager = hrc.getGoodyRenderRegistryClient().getJme3AssetManager(null);
                    String skyPath = "textures/skybox/Default/";
                    Spatial mySky = SkyFactory.createSky((AssetManager)assetManager, (Texture)assetManager.loadTexture(skyPath + "West.png"), (Texture)assetManager.loadTexture(skyPath + "East.png"), (Texture)assetManager.loadTexture(skyPath + "North.png"), (Texture)assetManager.loadTexture(skyPath + "South.png"), (Texture)assetManager.loadTexture(skyPath + "Up.png"), (Texture)assetManager.loadTexture(skyPath + "Down.png"));
                    root.attachChild(mySky);
                }
                catch (Exception e) {
                    theLogger.error("Skybox background image failed to load:", (Throwable)e);
                }
                return null;
            }
        });
    }

    public void addHumanoidGoodies(VWorldEntityActionConsumer consumer, HumanoidRenderContext hrc) {
        GoodyRenderRegistryClient grrc = hrc.getGoodyRenderRegistryClient();
        Map<Ident, HumanoidFigure> humanoidFigures = hrc.getHumanoidFigureManager().getHumanoidFigures();
        for (Ident figureUri : humanoidFigures.keySet()) {
            theLogger.info("Adding a HumanoidFigureGoodyWrapper for {}", (Object)figureUri);
            HumanoidFigure figure = humanoidFigures.get(figureUri);
            VWorldHumanoidFigureEntity vhfe = new VWorldHumanoidFigureEntity(grrc, figureUri, figure);
            consumer.addGoody((VWorldEntity)vhfe);
        }
    }
}

