/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.render.model.humanoid;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.LoopMode;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import org.cogchar.api.humanoid.HumanoidFigureConfig;
import org.cogchar.render.model.humanoid.HumanoidFigure;
import org.cogchar.render.model.humanoid.HumanoidRagdollControl;

public class HumanoidFigure_SinbadTest
extends HumanoidFigure {
    public static String ANIM_STAND_FRONT = "StandUpFront";
    public static String ANIM_STAND_BACK = "StandUpBack";
    public static String ANIM_DANCE = "Dance";
    public static String ANIM_IDLE_TOP = "IdleTop";
    private static float DEFAULT_ANIM_BLEND_RATE = 0.5f;

    public HumanoidFigure_SinbadTest(HumanoidFigureConfig hfc) {
        super(hfc);
    }

    public void makeSinbadStandUp() {
        Vector3f v = new Vector3f();
        Node sceneNode = this.getFigureNode();
        HumanoidFigureConfig hfc = this.getFigureConfig();
        v.set(sceneNode.getLocalTranslation());
        v.y = hfc.getInitY().floatValue();
        sceneNode.setLocalTranslation(v);
        Quaternion q = new Quaternion();
        float[] angles = new float[3];
        sceneNode.getLocalRotation().toAngles(angles);
        q.fromAngleAxis(angles[1], Vector3f.UNIT_Y);
        sceneNode.setLocalRotation(q);
        AnimChannel animChan = this.getFigureAnimChannel();
        HumanoidRagdollControl ragdollControl = this.getRagdollControl();
        if (angles[0] < 0.0f) {
            animChan.setAnim(ANIM_STAND_BACK);
            ragdollControl.blendToKinematicMode(DEFAULT_ANIM_BLEND_RATE);
        } else {
            animChan.setAnim(ANIM_STAND_FRONT);
            ragdollControl.blendToKinematicMode(DEFAULT_ANIM_BLEND_RATE);
        }
    }

    public void runSinbadBoogieAnim() {
        try {
            AnimChannel animChan = this.getFigureAnimChannel();
            HumanoidRagdollControl ragdollControl = this.getRagdollControl();
            animChan.setAnim(ANIM_DANCE);
            ragdollControl.blendToKinematicMode(DEFAULT_ANIM_BLEND_RATE);
        }
        catch (Throwable t) {
            this.getLogger().warn("Character cannot boogie, nickname is: {}; {}", (Object)this.getNickname(), (Object)t);
        }
    }

    @Override
    public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
        super.onAnimCycleDone(control, channel, animName);
        if (channel.getAnimationName().equals(ANIM_STAND_BACK) || channel.getAnimationName().equals(ANIM_STAND_FRONT)) {
            channel.setLoopMode(LoopMode.DontLoop);
            channel.setAnim(ANIM_IDLE_TOP, 5.0f);
            channel.setLoopMode(LoopMode.Loop);
        }
    }
}

