/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.render.model.humanoid;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.asset.AssetManager;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.RagdollCollisionListener;
import com.jme3.bullet.control.KinematicRagdollControl;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.SkeletonDebugger;
import java.util.List;
import org.appdapter.core.log.BasicDebugger;
import org.appdapter.core.name.Ident;
import org.cogchar.api.humanoid.FigureBoneConfig;
import org.cogchar.api.humanoid.FigureBoneDesc;
import org.cogchar.api.humanoid.HumanoidFigureConfig;
import org.cogchar.render.model.bony.BoneState;
import org.cogchar.render.model.bony.FigureState;
import org.cogchar.render.model.bony.StickFigureTwister;
import org.cogchar.render.model.humanoid.HumanoidFigureModule;
import org.cogchar.render.model.humanoid.HumanoidRagdollControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanoidFigure
extends BasicDebugger
implements RagdollCollisionListener,
AnimEventListener {
    private static final Logger theLogger = LoggerFactory.getLogger(HumanoidFigure.class);
    private Node myJME3ModelSceneNode;
    private HumanoidRagdollControl myRagdollKinematicControl;
    private AnimChannel myJME3AnimChannel;
    private Skeleton myJMESkeleton;
    private SkeletonDebugger myJMESkeletonDebugger;
    private FigureState myFigureState;
    private HumanoidFigureConfig myHFConfig;
    private HumanoidFigureModule myHFModule;
    public static String SKEL_DEBUG_NAME = "hrwSkelDebg";
    private static float KRC_WEIGHT_THRESHOLD = 0.5f;
    private static float FACE_ANGLE_LIMIT = 1.5707964f;

    public HumanoidFigure(HumanoidFigureConfig hfc) {
        this.myHFConfig = hfc;
    }

    protected Node getFigureNode() {
        return this.myJME3ModelSceneNode;
    }

    protected HumanoidFigureConfig getFigureConfig() {
        return this.myHFConfig;
    }

    protected AnimChannel getFigureAnimChannel() {
        return this.myJME3AnimChannel;
    }

    protected HumanoidRagdollControl getRagdollControl() {
        return this.myRagdollKinematicControl;
    }

    protected Ident getCharIdent() {
        return this.myHFConfig.getFigureID();
    }

    protected String getNickname() {
        return this.myHFConfig.getNickname();
    }

    protected FigureBoneConfig getHBConfig() {
        return this.myHFConfig.getFigureBoneConfig();
    }

    protected Bone getFigureBone(String boneName) {
        Bone b = this.myJMESkeleton.getBone(boneName);
        return b;
    }

    protected Bone getFigureRootBone() {
        return this.myJMESkeleton.getRoots()[0];
    }

    public HumanoidFigureModule getModule() {
        return this.myHFModule;
    }

    public void setModule(HumanoidFigureModule module) {
        this.myHFModule = module;
    }

    public boolean loadMeshAndSkeletonIntoVWorld(AssetManager assetMgr, Node parentNode, PhysicsSpace ps) {
        String meshPath = this.myHFConfig.getMeshPath();
        try {
            this.myJME3ModelSceneNode = (Node)assetMgr.loadModel(meshPath);
        }
        catch (Throwable t) {
            this.getLogger().warn("Caught exception trying to load 3D mesh model at [{}]", (Object)meshPath, (Object)t);
            return false;
        }
        this.myJME3ModelSceneNode.setLocalScale(this.myHFConfig.getScale().floatValue());
        AnimControl humanoidControl = (AnimControl)this.myJME3ModelSceneNode.getControl(AnimControl.class);
        this.myJMESkeleton = humanoidControl.getSkeleton();
        this.initDebugSkeleton(assetMgr);
        this.myRagdollKinematicControl = new HumanoidRagdollControl(KRC_WEIGHT_THRESHOLD);
        this.attachRagdollBones();
        this.myJME3ModelSceneNode.addControl((Control)this.myRagdollKinematicControl);
        HumanoidFigure.applyHumanoidJointLimits(this.myRagdollKinematicControl);
        if (this.myHFConfig.getPhysicsFlag().booleanValue() && ps != null) {
            this.myRagdollKinematicControl.addCollisionListener(this);
            ps.add((Object)this.myRagdollKinematicControl);
        }
        parentNode.attachChild((Spatial)this.myJME3ModelSceneNode);
        Vector3f pos = new Vector3f(this.myHFConfig.getInitX().floatValue(), this.myHFConfig.getInitY().floatValue(), this.myHFConfig.getInitZ().floatValue());
        this.moveToPosition_onSceneThread(pos);
        this.myJME3AnimChannel = humanoidControl.createChannel();
        humanoidControl.addListener((AnimEventListener)this);
        return true;
    }

    public void detachFromVirtualWorld(Node parentNode, PhysicsSpace ps) {
        ps.remove((Object)this.myRagdollKinematicControl);
        parentNode.detachChild((Spatial)this.myJME3ModelSceneNode);
    }

    protected void becomeKinematicPuppet() {
        this.myRagdollKinematicControl.setKinematicMode();
    }

    protected void becomeFloppyRagdoll() {
        this.myRagdollKinematicControl.setEnabled(true);
        this.myRagdollKinematicControl.setRagdollMode();
    }

    protected void moveToPosition_onSceneThread(Vector3f pos) {
        this.myJME3ModelSceneNode.setLocalTranslation(pos);
    }

    protected void movePosition_onSceneThread(float deltaX, float deltaY, float deltaZ) {
        Vector3f v = new Vector3f();
        v.set(this.myJME3ModelSceneNode.getLocalTranslation());
        v.x += deltaX;
        v.y += deltaY;
        v.z += deltaZ;
        this.myJME3ModelSceneNode.setLocalTranslation(v);
    }

    public Node getNode() {
        return this.myJME3ModelSceneNode;
    }

    public void collide(Bone bone, PhysicsCollisionObject pco, PhysicsCollisionEvent pce) {
        Object userObj = pco.getUserObject();
        if (userObj != null && userObj instanceof Geometry) {
            Geometry geom = (Geometry)userObj;
            if (geom.getName().toLowerCase().contains("Floor".toLowerCase())) {
                return;
            }
            theLogger.info("Bone {} collided with userObj-geom named {}, which is not the floor", (Object)bone.getName(), (Object)geom.getName());
        } else {
            theLogger.info("Bone {} collided with something, userObj is {}", (Object)bone.getName(), userObj);
        }
        this.myRagdollKinematicControl.setRagdollMode();
    }

    public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
        theLogger.info("AnimCycleDone {}", (Object)animName);
    }

    public void onAnimChange(AnimControl control, AnimChannel channel, String animName) {
    }

    public void initDebugSkeleton(AssetManager assetMgr) {
        if (this.myJMESkeletonDebugger == null) {
            this.myJMESkeletonDebugger = new SkeletonDebugger(SKEL_DEBUG_NAME, this.myJMESkeleton);
            String unshadedMatPath = this.myHFConfig.getDebugSkelMatPath();
            Material mat2 = new Material(assetMgr, unshadedMatPath);
            mat2.getAdditionalRenderState().setWireframe(true);
            mat2.setColor("Color", ColorRGBA.Green);
            mat2.getAdditionalRenderState().setDepthTest(false);
            this.myJMESkeletonDebugger.setMaterial(mat2);
        }
        this.myJMESkeletonDebugger.setLocalTranslation(this.myJME3ModelSceneNode.getLocalTranslation());
    }

    public void toggleDebugSkeleton_onSceneThread() {
        if (this.myJME3ModelSceneNode != null) {
            if (this.myJME3ModelSceneNode.hasChild((Spatial)this.myJMESkeletonDebugger)) {
                this.myJME3ModelSceneNode.detachChild((Spatial)this.myJMESkeletonDebugger);
            } else {
                this.myJME3ModelSceneNode.attachChild((Spatial)this.myJMESkeletonDebugger);
            }
        }
    }

    protected void attachRagdollBone(FigureBoneDesc hbd) {
        this.myRagdollKinematicControl.addBoneName(hbd.getBoneName());
    }

    public FigureState getFigureState() {
        return this.myFigureState;
    }

    public void setFigureState(FigureState fs) {
        this.myFigureState = fs;
    }

    public void applyFigureState_onSceneThread(FigureState fs) {
        if (fs == null) {
            return;
        }
        FigureBoneConfig hbc = this.getHBConfig();
        List boneDescs = hbc.getBoneDescs();
        if (boneDescs.size() == 0) {
            theLogger.warn("Found 0 boneDescs to map to for figure {}", (Object)this.myHFConfig);
        }
        theLogger.trace("Applying figureState {} to {} boneDescs[{}]", new Object[]{fs, boneDescs.size(), boneDescs});
        boolean debugModulator = false;
        for (FigureBoneDesc hbd : boneDescs) {
            String boneName = hbd.getBoneName();
            BoneState bs = fs.getBoneState(boneName);
            Bone tgtBone = this.getFigureBone(boneName);
            if (bs != null && tgtBone != null) {
                Quaternion boneRotQuat = bs.getRotQuat();
                Vector3f boneTranslateVec = null;
                Vector3f boneScaleVec = null;
                StickFigureTwister.applyBoneTransforms_onSceneThread((Bone)tgtBone, boneTranslateVec, (Quaternion)boneRotQuat, boneScaleVec);
                continue;
            }
            theLogger.debug("Skipping boneState {} and tgtBone {}, for boneName {}", new Object[]{bs, tgtBone, boneName});
        }
    }

    private float getNormalizedLinearMap(float rotation, boolean symmetric) {
        return symmetric ? rotation / FACE_ANGLE_LIMIT : (rotation / FACE_ANGLE_LIMIT + 1.0f) / 2.0f;
    }

    public void attachRagdollBones() {
        FigureBoneConfig hbc = this.getHBConfig();
        List boneDescs = hbc.getBoneDescs();
        for (FigureBoneDesc hbd : boneDescs) {
            this.attachRagdollBone(hbd);
        }
    }

    public Node getBoneAttachmentsNode(String boneName) {
        if (this.myJME3ModelSceneNode != null) {
            SkeletonControl sc = (SkeletonControl)this.myJME3ModelSceneNode.getControl(SkeletonControl.class);
            return sc.getAttachmentsNode(boneName);
        }
        return null;
    }

    private static void applyHumanoidJointLimits(KinematicRagdollControl krc) {
        float eighth_pi = 0.3926991f;
        krc.setJointLimit("Waist", eighth_pi, eighth_pi, eighth_pi, eighth_pi, eighth_pi, eighth_pi);
        krc.setJointLimit("Chest", eighth_pi, eighth_pi, 0.0f, 0.0f, eighth_pi, eighth_pi);
    }
}

