/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.render.model.humanoid;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.AnimationFactory;
import com.jme3.animation.LoopMode;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.control.Control;
import java.util.concurrent.Callable;
import org.appdapter.core.name.Ident;
import org.cogchar.render.app.entity.GoodyActionExtractor;
import org.cogchar.render.app.entity.VWorldEntity;
import org.cogchar.render.model.humanoid.HumanoidFigure;
import org.cogchar.render.sys.goody.GoodyRenderRegistryClient;
import org.cogchar.render.sys.task.Queuer;

public class VWorldHumanoidFigureEntity
extends VWorldEntity {
    static final String MOVE_ANIM_NAME = "HumanoidFigureMoveFactory";
    private Node myNode;
    private AnimControl figureControl = new AnimControl();

    public VWorldHumanoidFigureEntity(GoodyRenderRegistryClient aRenderRegCli, Ident figureUri, HumanoidFigure hf) {
        super(aRenderRegCli, figureUri);
        this.myNode = hf.getNode();
    }

    public void setPosition(final Vector3f position, Queuer.QueueingStyle qStyle) {
        this.clearMoveAnimationBindings();
        this.enqueueForJme(new Callable(){

            public Void call() throws Exception {
                VWorldHumanoidFigureEntity.this.myNode.setLocalTranslation(position);
                return null;
            }
        }, qStyle);
    }

    public void setRotation(final Quaternion rotation, Queuer.QueueingStyle qStyle) {
        this.clearMoveAnimationBindings();
        this.enqueueForJme(new Callable(){

            public Void call() throws Exception {
                VWorldHumanoidFigureEntity.this.myNode.setLocalRotation(rotation);
                return null;
            }
        }, qStyle);
    }

    protected void setNewPositionAndRotationIfNonNull(Vector3f newPosition, Quaternion newRotation, Queuer.QueueingStyle qStyle) {
        if (newPosition != null) {
            this.setPosition(newPosition, qStyle);
        }
        if (newRotation != null) {
            this.setRotation(newRotation, qStyle);
        }
    }

    protected void moveViaAnimation(Vector3f newPosition, Quaternion newOrientation, float duration) {
        this.clearMoveAnimationBindings();
        Vector3f currentPosition = this.myNode.getLocalTranslation();
        Quaternion currentOrientation = this.myNode.getLocalRotation();
        if (newPosition == null) {
            newPosition = currentPosition;
        }
        if (newOrientation == null) {
            newOrientation = currentOrientation;
        }
        AnimationFactory aniFactory = new AnimationFactory(duration, MOVE_ANIM_NAME);
        aniFactory.addKeyFrameTranslation(0, currentPosition);
        aniFactory.addKeyFrameRotation(0, currentOrientation);
        aniFactory.addTimeTranslation(duration, newPosition);
        aniFactory.addTimeRotation(duration, newOrientation);
        Animation moveAnimation = aniFactory.buildAnimation();
        this.figureControl.addAnim(moveAnimation);
        this.myNode.addControl((Control)this.figureControl);
        AnimChannel moveChannel = this.figureControl.createChannel();
        moveChannel.setAnim(MOVE_ANIM_NAME, 0.0f);
        moveChannel.setLoopMode(LoopMode.DontLoop);
    }

    private void clearMoveAnimationBindings() {
        this.myNode.removeControl((Control)this.figureControl);
        Animation oldAnim = this.figureControl.getAnim(MOVE_ANIM_NAME);
        if (oldAnim != null) {
            this.figureControl.removeAnim(oldAnim);
        }
    }

    public void setUniformScaleFactor(Float scale, Queuer.QueueingStyle qStyle) {
        this.getLogger().warn("setScale not supported in HumanoidFigureGoodyWrapper");
    }

    public void attachToVirtualWorldNode(Node attachmentNode, Queuer.QueueingStyle qStyle) {
        this.getLogger().warn("attachToVirtualWorldNode not supported in HumanoidFigureGoodyWrapper");
    }

    public void detachFromVirtualWorldNode(Queuer.QueueingStyle qStyle) {
        this.getLogger().warn("detachFromVirtualWorldNode not supported in HumanoidFigureGoodyWrapper");
    }

    public void applyAction(GoodyActionExtractor ga, Queuer.QueueingStyle qStyle) {
        Vector3f newLocation = ga.getLocationVec3f();
        Quaternion newRotation = ga.getRotationQuaternion();
        switch (ga.getKind()) {
            case SET: {
                this.setNewPositionAndRotationIfNonNull(newLocation, newRotation, qStyle);
                break;
            }
            case MOVE: {
                Float timeEnroute = ga.getTravelTime();
                if (timeEnroute == null) {
                    this.setNewPositionAndRotationIfNonNull(newLocation, newRotation, qStyle);
                    break;
                }
                this.moveViaAnimation(newLocation, newRotation, timeEnroute.floatValue());
                break;
            }
            default: {
                this.getLogger().error("Unknown action requested in HumanoidFigureGoodyWrapper {}: {}", (Object)this.getUri().getLocalName(), (Object)ga.getKind().name());
            }
        }
    }
}

