/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.render.app.humanoid;

import com.jme3.input.FlyByCamera;
import com.jme3.system.AppSettings;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import org.cogchar.blob.emit.RenderConfigEmitter;
import org.cogchar.platform.gui.keybind.KeyBindingConfig;
import org.cogchar.platform.trigger.CommandSpace;
import org.cogchar.render.app.bony.BonyVirtualCharApp;
import org.cogchar.render.app.core.WorkaroundAppStub;
import org.cogchar.render.gui.bony.VirtualCharacterPanel;
import org.cogchar.render.model.humanoid.HumanoidFigureManager;
import org.cogchar.render.opengl.optic.CameraMgr;
import org.cogchar.render.opengl.scene.FigureBoneNodeFinder;
import org.cogchar.render.sys.goody.GoodyModularRenderContext;
import org.cogchar.render.sys.goody.GoodyRenderRegistryClient;
import org.cogchar.render.sys.input.VW_InputBindingFuncs;
import org.cogchar.render.sys.registry.RenderRegistryClient;

public class HumanoidRenderContext
extends GoodyModularRenderContext {
    private HumanoidFigureManager myHFM = new HumanoidFigureManager();

    public HumanoidRenderContext(GoodyRenderRegistryClient grrc, RenderConfigEmitter rce) {
        super(grrc, rce);
    }

    public void postInitLaunch() {
        super.postInitLaunch();
        this.initBasicTestPhysics();
    }

    public void setupHominoidCameraManager() {
        RenderRegistryClient rrc = this.getRenderRegistryClient();
        CameraMgr cmgr = rrc.getOpticCameraFacade(null);
        cmgr.setAttachmentNodeFinder((FigureBoneNodeFinder)this.myHFM);
    }

    public void initCinematicParameters() {
        WorkaroundAppStub stub = this.getAppStub();
        FlyByCamera fbCam = stub.getFlyByCamera();
        fbCam.setMoveSpeed(50.0f);
    }

    public void refreshInputBindingsAndHelpScreen(KeyBindingConfig keyBindConfig, CommandSpace cspace) {
        RenderRegistryClient rrc = this.getRenderRegistryClient();
        VW_InputBindingFuncs.setupKeyBindingsAndHelpScreen((RenderRegistryClient)rrc, (KeyBindingConfig)keyBindConfig, (WorkaroundAppStub)this.getAppStub(), (AppSettings)this.getJMonkeyAppSettings(), (CommandSpace)cspace);
    }

    public void setDefaultCameraLocation() {
        RenderRegistryClient rrc = this.getRenderRegistryClient();
        CameraMgr cmgr = rrc.getOpticCameraFacade(null);
        cmgr.resetDefaultCamera();
    }

    public HumanoidFigureManager getHumanoidFigureManager() {
        return this.myHFM;
    }

    public void startOpenGLCanvas(boolean wrapInJFrameFlag, WindowListener optWindowEventListener) throws Exception {
        BonyVirtualCharApp app;
        if (wrapInJFrameFlag) {
            VirtualCharacterPanel vcp = this.getPanel();
            this.logInfo("Making enclosing JFrame for VirtCharPanel: " + vcp);
            JFrame jf = vcp.makeEnclosingJFrame("CCRK-PUMA Virtual World");
            this.logInfo("Got Enclosing Frame, adding to BonyRenderContext for WindowClose triggering: " + jf);
            this.setFrame(jf);
            if (optWindowEventListener != null) {
                jf.addWindowListener(optWindowEventListener);
            }
        }
        if ((app = this.getApp()).isCanvasStarted()) {
            this.logWarning("JMonkey Canvas was already started!");
        } else {
            this.logInfo("Starting JMonkey canvas - hold yer breath! [[[[[[[[[[[[[[[[[[[[[[[[[[");
            app.startJMonkeyCanvas();
            this.logInfo("]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]  Finished starting JMonkey canvas!");
        }
    }
}

