/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.render.model.humanoid;

import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.joints.motors.RotationalLimitMotor;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.FastMath;
import java.util.List;
import org.cogchar.api.humanoid.HumanoidBoneConfig;
import org.cogchar.api.humanoid.HumanoidBoneDesc;
import org.cogchar.api.humanoid.HumanoidFigureConfig;
import org.cogchar.render.model.humanoid.HumanoidFigure;
import org.cogchar.render.model.humanoid.HumanoidRagdollControl;

public class PhysicallyWigglingHumanoid
extends HumanoidFigure {
    private float myPhysicsWigglePhase = 0.0f;

    public PhysicallyWigglingHumanoid(HumanoidFigureConfig hfc) {
        super(hfc);
    }

    public void wiggleUsingPhysics(float tpf) {
        this.wiggleUsingPhysicsMotors(this.getHBConfig(), tpf);
    }

    public void wiggleUsingPhysicsMotors(HumanoidBoneConfig hbc, float tpf) {
        this.myPhysicsWigglePhase += tpf / 10.0f;
        if (this.myPhysicsWigglePhase > 1.0f) {
            System.out.println("************ Wiggle phase reset ------ hmmmm, OK");
            this.myPhysicsWigglePhase = 0.0f;
        }
        float amplitude = 5.0f;
        float wigglePhaseRad = (float)Math.PI * 2 * this.myPhysicsWigglePhase;
        float wiggleVel = amplitude * FastMath.sin2((float)wigglePhaseRad);
        wiggleVel = (double)this.myPhysicsWigglePhase < 0.5 ? amplitude : -1.0f * amplitude;
        this.wiggleAllBonesUsingRotMotors(hbc, wiggleVel);
    }

    private void wiggleAllBonesUsingRotMotors(HumanoidBoneConfig hbc, float wiggleVel) {
        List descs = hbc.getBoneDescs();
        for (HumanoidBoneDesc hbd : descs) {
            String boneName = hbd.getSpatialName();
            HumanoidRagdollControl hkrc = this.getRagdollControl();
            PhysicsRigidBody prb = hkrc.getBoneRigidBody(boneName);
            SixDofJoint boneJoint = hkrc.getJoint(boneName);
            RotationalLimitMotor xRotMotor = boneJoint.getRotationalLimitMotor(0);
            RotationalLimitMotor yRotMotor = boneJoint.getRotationalLimitMotor(1);
            RotationalLimitMotor zRotMotor = boneJoint.getRotationalLimitMotor(2);
            xRotMotor.setTargetVelocity(wiggleVel);
            yRotMotor.setTargetVelocity(wiggleVel);
            zRotMotor.setTargetVelocity(wiggleVel);
        }
    }
}

