/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.render.app.humanoid;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.cogchar.blob.emit.RenderConfigEmitter;
import org.cogchar.render.app.bony.BonyRenderContext;
import org.cogchar.render.app.bony.BonyVirtualCharApp;
import org.cogchar.render.app.humanoid.HumanoidPuppetApp;
import org.cogchar.render.app.humanoid.HumanoidRenderContext;
import org.cogchar.render.gui.bony.PanelUtils;
import org.cogchar.render.gui.bony.VirtualCharacterPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanoidPuppetTestMain {
    static Logger theLogger = LoggerFactory.getLogger(HumanoidPuppetTestMain.class);

    public static BonyRenderContext makeBonyRenderContextWithApp(RenderConfigEmitter rce) {
        HumanoidPuppetApp bvcApp = new HumanoidPuppetApp(rce);
        VirtualCharacterPanel vcp = PanelUtils.makeVCPanel((RenderConfigEmitter)rce, (String)"FULL");
        bvcApp.initCharPanelWithCanvas(vcp);
        BonyRenderContext bc = bvcApp.getBonyRenderContext();
        return bc;
    }

    public static void main(String[] args) {
        try {
            HumanoidPuppetTestMain.startTest();
        }
        catch (Throwable t) {
            theLogger.error("Caught Exception", t);
        }
    }

    public static void startTest() throws Throwable {
        RenderConfigEmitter rce = new RenderConfigEmitter();
        final BonyRenderContext bc = HumanoidPuppetTestMain.makeBonyRenderContextWithApp(rce);
        VirtualCharacterPanel vcp = bc.getPanel();
        JFrame jf = vcp.makeEnclosingJFrame("Humanoid Puppet Test");
        bc.setFrame(jf);
        jf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                theLogger.info("StickFigureTestMain.JFrame.windowClosing event:  {}", (Object)e);
                theLogger.info("NOT explicitly calling requestClose() on the app, letting the LWJGL thread detect dispose of the canvas instead");
                BonyVirtualCharApp app = bc.getApp();
                theLogger.info("StickFigureTestMain.JFrame.windowClosing - END");
            }

            @Override
            public void windowClosed(WindowEvent e) {
                theLogger.info("VirtCharPanel.JFrame Window CLOSED event:  {}", (Object)e);
                System.out.println("VirtCharPanel.JFrame.closed, exiting");
                System.exit(0);
            }
        });
        BonyVirtualCharApp app = bc.getApp();
        app.startJMonkeyCanvas();
        HumanoidRenderContext hrc = (HumanoidRenderContext)app.getBonyRenderContext();
        hrc.runPostInitLaunchOnJmeThread();
        hrc.initCinematicParameters();
        hrc.getGameFeatureAdapter().setScoringFlag(true);
        theLogger.info("*********************** Frame width={}, height={}", (Object)jf.getWidth(), (Object)jf.getHeight());
    }
}

