/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.render.optic.hominoid;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Node;
import com.jme3.scene.control.CameraControl;
import org.cogchar.api.cinema.CameraConfig;
import org.cogchar.render.app.bony.BonyRenderContext;
import org.cogchar.render.app.humanoid.HumanoidRenderContext;
import org.cogchar.render.model.humanoid.HumanoidFigureManager;
import org.cogchar.render.opengl.optic.CameraMgr;
import org.cogchar.render.sys.context.CogcharRenderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HominoidCameraManager
implements CameraMgr.HeadCameraManager {
    static Logger theLogger = LoggerFactory.getLogger(HominoidCameraManager.class);

    public void addHeadCamera(Camera headCam, CameraConfig config, CogcharRenderContext crc) {
        if (crc != null) {
            HumanoidRenderContext hrc = (HumanoidRenderContext)crc;
            HumanoidFigureManager hfm = hrc.getHumanoidFigureManager();
            CameraNode headCamNode = new CameraNode(CameraMgr.CommonCameras.HEAD_CAM.name() + "_NODE", headCam);
            headCamNode.setControlDir(CameraControl.ControlDirection.SpatialToCamera);
            hfm.attachNodeToHumanoidBone((BonyRenderContext)hrc, (Node)headCamNode, config.attachedRobot, config.attachedItem);
            float[] cameraPos = config.cameraPosition;
            float[] cameraDir = config.cameraPointDir;
            headCamNode.setLocalTranslation(new Vector3f(cameraPos[0], cameraPos[1], cameraPos[2]));
            headCamNode.setLocalRotation(new Quaternion().fromAngles(cameraDir));
        } else {
            theLogger.warn("Attempting to add head camera, but HumanoidRenderContext has not been set!");
        }
    }
}

