/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.render.model.humanoid;

import com.jme3.asset.AssetManager;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.appdapter.api.module.Module;
import org.appdapter.core.log.BasicDebugger;
import org.appdapter.core.name.Ident;
import org.appdapter.help.repo.RepoClient;
import org.cogchar.api.humanoid.HumanoidConfig;
import org.cogchar.api.humanoid.HumanoidFigureConfig;
import org.cogchar.blob.emit.RenderConfigEmitter;
import org.cogchar.platform.task.CallableTask;
import org.cogchar.render.app.bony.BonyRenderContext;
import org.cogchar.render.model.humanoid.HumanoidFigure;
import org.cogchar.render.model.humanoid.HumanoidFigureModule;
import org.cogchar.render.sys.registry.RenderRegistryClient;
import org.cogchar.render.sys.registry.RenderRegistryClientFinder;
import org.cogchar.render.sys.task.BasicCallableRenderTask;

public class HumanoidFigureManager
extends BasicDebugger {
    private Map<Ident, HumanoidFigure> myFiguresByCharIdent = new HashMap<Ident, HumanoidFigure>();

    public HumanoidFigure getOrMakeHumanoidFigure(RepoClient qi, Ident charIdent, HumanoidConfig hc, Ident bonyConfigGraph, RenderConfigEmitter rce) {
        String matPath;
        HumanoidFigureConfig hfc;
        HumanoidFigure hf = this.myFiguresByCharIdent.get(charIdent);
        if (hf == null && (hfc = new HumanoidFigureConfig(qi, hc, matPath = rce.getMaterialPath(), bonyConfigGraph)).isComplete()) {
            hf = new HumanoidFigure(hfc);
            this.myFiguresByCharIdent.put(charIdent, hf);
        }
        return hf;
    }

    public HumanoidFigure getHumanoidFigure(Ident charIdent) {
        return this.myFiguresByCharIdent.get(charIdent);
    }

    public Map<Ident, HumanoidFigure> getHumanoidFigures() {
        return this.myFiguresByCharIdent;
    }

    public HumanoidFigure setupHumanoidFigure(final BonyRenderContext brc, RepoClient qi, final Ident charIdent, Ident bonyConfigGraph, HumanoidConfig hc) throws Throwable {
        RenderRegistryClient rrc = brc.getRenderRegistryClient();
        RenderConfigEmitter rce = brc.getConfigEmitter();
        final HumanoidFigure figure = this.getOrMakeHumanoidFigure(qi, charIdent, hc, bonyConfigGraph, rce);
        final AssetManager amgr = rrc.getJme3AssetManager(null);
        final Node rootNode = rrc.getJme3RootDeepNode(null);
        final PhysicsSpace ps = brc.getPhysicsSpace();
        if (figure == null) {
            this.getLogger().warn("setupHumanoidFigure() Found null HumanoidFigure for {}", (Object)charIdent);
            return null;
        }
        brc.runTaskSafelyUntilComplete((CallableTask)new BasicCallableRenderTask((RenderRegistryClientFinder)brc){

            public void performWithClient(RenderRegistryClient rrc) throws Throwable {
                boolean figureInitOK = figure.loadMeshAndSkeletonIntoVWorld(amgr, rootNode, ps);
                if (figureInitOK) {
                    HumanoidFigureModule hfm = new HumanoidFigureModule(figure, brc);
                    figure.setModule(hfm);
                    brc.attachModule((Module)hfm);
                    this.getLogger().warn("Async Result (not really a 'warning') : Figure initialized and HumanoidFigureModule attached for {}", (Object)charIdent);
                } else {
                    this.getLogger().warn("Delayed problem in code launched from setupHumanoidFigure():  Figure init failed for: {}", (Object)charIdent);
                }
            }
        });
        return figure;
    }

    public void detachHumanoidFigures(final BonyRenderContext brc) {
        RenderRegistryClient rrc = brc.getRenderRegistryClient();
        final Node rootNode = rrc.getJme3RootDeepNode(null);
        final PhysicsSpace ps = brc.getPhysicsSpace();
        for (final HumanoidFigure aHumanoid : this.myFiguresByCharIdent.values()) {
            brc.enqueueCallable((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    brc.detachModule((Module)aHumanoid.getModule());
                    aHumanoid.detachFromVirtualWorld(rootNode, ps);
                    return null;
                }
            });
        }
        this.myFiguresByCharIdent.clear();
    }

    public void toggleDebugSkeletons() {
        for (HumanoidFigure hf : this.myFiguresByCharIdent.values()) {
            hf.toggleDebugSkeleton();
        }
    }

    public void attachNodeToHumanoidBone(BonyRenderContext brc, final Node toAttach, final Ident robotIdent, final String boneName) {
        final HumanoidFigure robot = this.getHumanoidFigure(robotIdent);
        if (robot == null) {
            this.getLogger().warn("Failed to attach node[{}] to humanoid's {} due to missing robot: {}", new Object[]{toAttach, boneName, robotIdent});
        } else {
            brc.enqueueCallable((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Node attachToBone = robot.getBoneAttachmentsNode(boneName);
                    if (attachToBone != null) {
                        attachToBone.attachChild((Spatial)toAttach);
                    } else {
                        HumanoidFigureManager.this.getLogger().warn("Delayed failure to attach node[{}] to humanoid, due to missing bone {} on robot: {}", new Object[]{toAttach, boneName, robotIdent});
                    }
                    return null;
                }
            });
        }
    }
}

