/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.render.model.humanoid;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.Bone;
import com.jme3.animation.LoopMode;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.asset.AssetManager;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.RagdollCollisionListener;
import com.jme3.bullet.control.KinematicRagdollControl;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.SkeletonDebugger;
import java.util.List;
import org.appdapter.core.log.BasicDebugger;
import org.appdapter.core.name.Ident;
import org.cogchar.api.humanoid.HumanoidBoneConfig;
import org.cogchar.api.humanoid.HumanoidBoneDesc;
import org.cogchar.api.humanoid.HumanoidFigureConfig;
import org.cogchar.render.model.bony.BoneState;
import org.cogchar.render.model.bony.FigureState;
import org.cogchar.render.model.bony.StickFigureTwister;
import org.cogchar.render.model.humanoid.HumanoidFigureModule;
import org.cogchar.render.model.humanoid.HumanoidRagdollControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanoidFigure
extends BasicDebugger
implements RagdollCollisionListener,
AnimEventListener {
    private static final Logger theLogger = LoggerFactory.getLogger(HumanoidFigure.class);
    private Node myHumanoidModelNode;
    private HumanoidRagdollControl myHumanoidKRC;
    private AnimChannel myHumanoidAnimChannel;
    private Skeleton myHumanoidSkeleton;
    private SkeletonDebugger myHumanoidSkeletonDebugger;
    private FigureState myFigureState;
    private HumanoidFigureConfig myConfig;
    private HumanoidFigureModule myModule;
    public static String ANIM_STAND_FRONT = "StandUpFront";
    public static String ANIM_STAND_BACK = "StandUpBack";
    public static String ANIM_DANCE = "Dance";
    public static String ANIM_IDLE_TOP = "IdleTop";
    public static String SKEL_DEBUG_NAME = "hrwSkelDebg";
    private static float DEFAULT_ANIM_BLEND_RATE = 0.5f;
    private static float KRC_WEIGHT_THRESHOLD = 0.5f;
    private static float FACE_ANGLE_LIMIT = 1.5707964f;

    public HumanoidFigure(HumanoidFigureConfig hfc) {
        this.myConfig = hfc;
    }

    protected HumanoidRagdollControl getRagdollControl() {
        return this.myHumanoidKRC;
    }

    protected Ident getCharIdent() {
        return this.myConfig.myCharIdent;
    }

    protected String getNickname() {
        return this.myConfig.myNickname;
    }

    protected HumanoidBoneConfig getHBConfig() {
        return this.myConfig.myBoneConfig;
    }

    protected Bone getSpatialBone(String boneName) {
        Bone b = this.myHumanoidSkeleton.getBone(boneName);
        return b;
    }

    protected Bone getRootBone() {
        return this.myHumanoidSkeleton.getRoots()[0];
    }

    public HumanoidFigureModule getModule() {
        return this.myModule;
    }

    public void setModule(HumanoidFigureModule module) {
        this.myModule = module;
    }

    public boolean loadMeshAndSkeletonIntoVWorld(AssetManager assetMgr, Node parentNode, PhysicsSpace ps) {
        try {
            this.myHumanoidModelNode = (Node)assetMgr.loadModel(this.myConfig.myMeshPath);
        }
        catch (Throwable t) {
            this.getLogger().warn("Caught exception trying to load 3D mesh model at [{}]", (Object)this.myConfig.myMeshPath, (Object)t);
            return false;
        }
        this.myHumanoidModelNode.setLocalScale(this.myConfig.myScale);
        AnimControl humanoidControl = (AnimControl)this.myHumanoidModelNode.getControl(AnimControl.class);
        this.myHumanoidSkeleton = humanoidControl.getSkeleton();
        this.initDebugSkeleton(assetMgr);
        this.myHumanoidKRC = new HumanoidRagdollControl(KRC_WEIGHT_THRESHOLD);
        this.attachRagdollBones();
        this.myHumanoidModelNode.addControl((Control)this.myHumanoidKRC);
        HumanoidFigure.applyHumanoidJointLimits(this.myHumanoidKRC);
        if (this.myConfig.myPhysicsFlag && ps != null) {
            this.myHumanoidKRC.addCollisionListener(this);
            ps.add((Object)this.myHumanoidKRC);
        }
        parentNode.attachChild((Spatial)this.myHumanoidModelNode);
        Vector3f pos = new Vector3f(this.myConfig.myInitX, this.myConfig.myInitY, this.myConfig.myInitZ);
        this.moveToPosition(pos);
        this.myHumanoidAnimChannel = humanoidControl.createChannel();
        humanoidControl.addListener((AnimEventListener)this);
        return true;
    }

    public void detachFromVirtualWorld(Node parentNode, PhysicsSpace ps) {
        ps.remove((Object)this.myHumanoidKRC);
        parentNode.detachChild((Spatial)this.myHumanoidModelNode);
    }

    protected void becomeKinematicPuppet() {
        this.myHumanoidKRC.setKinematicMode();
    }

    protected void becomeFloppyRagdoll() {
        this.myHumanoidKRC.setEnabled(true);
        this.myHumanoidKRC.setRagdollMode();
    }

    public void makeSinbadStandUp() {
        Vector3f v = new Vector3f();
        v.set(this.myHumanoidModelNode.getLocalTranslation());
        v.y = this.myConfig.myInitY;
        this.myHumanoidModelNode.setLocalTranslation(v);
        Quaternion q = new Quaternion();
        float[] angles = new float[3];
        this.myHumanoidModelNode.getLocalRotation().toAngles(angles);
        q.fromAngleAxis(angles[1], Vector3f.UNIT_Y);
        this.myHumanoidModelNode.setLocalRotation(q);
        if (angles[0] < 0.0f) {
            this.myHumanoidAnimChannel.setAnim(ANIM_STAND_BACK);
            this.myHumanoidKRC.blendToKinematicMode(DEFAULT_ANIM_BLEND_RATE);
        } else {
            this.myHumanoidAnimChannel.setAnim(ANIM_STAND_FRONT);
            this.myHumanoidKRC.blendToKinematicMode(DEFAULT_ANIM_BLEND_RATE);
        }
    }

    protected void moveToPosition(Vector3f pos) {
        this.myHumanoidModelNode.setLocalTranslation(pos);
    }

    protected void movePosition(float deltaX, float deltaY, float deltaZ) {
        Vector3f v = new Vector3f();
        v.set(this.myHumanoidModelNode.getLocalTranslation());
        v.x += deltaX;
        v.y += deltaY;
        v.z += deltaZ;
        this.myHumanoidModelNode.setLocalTranslation(v);
    }

    public Node getNode() {
        return this.myHumanoidModelNode;
    }

    public void collide(Bone bone, PhysicsCollisionObject pco, PhysicsCollisionEvent pce) {
        Object userObj = pco.getUserObject();
        if (userObj != null && userObj instanceof Geometry) {
            Geometry geom = (Geometry)userObj;
            if (geom.getName().toLowerCase().contains("Floor".toLowerCase())) {
                return;
            }
            theLogger.info("Bone {} collided with userObj-geom named {}, which is not the floor", (Object)bone.getName(), (Object)geom.getName());
        } else {
            theLogger.info("Bone {} collided with something, userObj is {}", (Object)bone.getName(), userObj);
        }
        this.myHumanoidKRC.setRagdollMode();
    }

    public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
        theLogger.info("AnimCycleDone {}", (Object)animName);
        if (channel.getAnimationName().equals(ANIM_STAND_BACK) || channel.getAnimationName().equals(ANIM_STAND_FRONT)) {
            channel.setLoopMode(LoopMode.DontLoop);
            channel.setAnim(ANIM_IDLE_TOP, 5.0f);
            channel.setLoopMode(LoopMode.Loop);
        }
    }

    public void onAnimChange(AnimControl control, AnimChannel channel, String animName) {
    }

    public void runSinbadBoogieAnim() {
        try {
            this.myHumanoidAnimChannel.setAnim(ANIM_DANCE);
            this.myHumanoidKRC.blendToKinematicMode(DEFAULT_ANIM_BLEND_RATE);
        }
        catch (Throwable t) {
            this.getLogger().warn("Character cannot boogie, nickname is: {}; {}", (Object)this.getNickname(), (Object)t);
        }
    }

    public void initDebugSkeleton(AssetManager assetMgr) {
        if (this.myHumanoidSkeletonDebugger == null) {
            this.myHumanoidSkeletonDebugger = new SkeletonDebugger(SKEL_DEBUG_NAME, this.myHumanoidSkeleton);
            String unshadedMatPath = this.myConfig.myDebugSkelMatPath;
            Material mat2 = new Material(assetMgr, unshadedMatPath);
            mat2.getAdditionalRenderState().setWireframe(true);
            mat2.setColor("Color", ColorRGBA.Green);
            mat2.getAdditionalRenderState().setDepthTest(false);
            this.myHumanoidSkeletonDebugger.setMaterial(mat2);
        }
        this.myHumanoidSkeletonDebugger.setLocalTranslation(this.myHumanoidModelNode.getLocalTranslation());
    }

    public void toggleDebugSkeleton() {
        if (this.myHumanoidModelNode != null) {
            if (this.myHumanoidModelNode.hasChild((Spatial)this.myHumanoidSkeletonDebugger)) {
                this.myHumanoidModelNode.detachChild((Spatial)this.myHumanoidSkeletonDebugger);
            } else {
                this.myHumanoidModelNode.attachChild((Spatial)this.myHumanoidSkeletonDebugger);
            }
        }
    }

    protected void attachRagdollBone(HumanoidBoneDesc hbd) {
        this.myHumanoidKRC.addBoneName(hbd.getSpatialName());
    }

    public FigureState getFigureState() {
        return this.myFigureState;
    }

    public void setFigureState(FigureState fs) {
        this.myFigureState = fs;
    }

    public void applyFigureState(FigureState fs) {
        if (fs == null) {
            return;
        }
        HumanoidBoneConfig hbc = this.getHBConfig();
        List boneDescs = hbc.getBoneDescs();
        boolean debugModulator = false;
        for (HumanoidBoneDesc hbd : boneDescs) {
            String boneName = hbd.getSpatialName();
            BoneState bs = fs.getBoneState(boneName);
            Bone tgtBone = this.getSpatialBone(boneName);
            if (bs == null || tgtBone == null) continue;
            Quaternion boneRotQuat = bs.getRotQuat();
            Vector3f boneTranslateVec = null;
            Vector3f boneScaleVec = null;
            StickFigureTwister.applyBoneTransforms((Bone)tgtBone, boneTranslateVec, (Quaternion)boneRotQuat, boneScaleVec);
        }
    }

    private float getNormalizedLinearMap(float rotation, boolean symmetric) {
        return symmetric ? rotation / FACE_ANGLE_LIMIT : (rotation / FACE_ANGLE_LIMIT + 1.0f) / 2.0f;
    }

    public void attachRagdollBones() {
        HumanoidBoneConfig hbc = this.getHBConfig();
        List boneDescs = hbc.getBoneDescs();
        for (HumanoidBoneDesc hbd : boneDescs) {
            this.attachRagdollBone(hbd);
        }
    }

    public Node getBoneAttachmentsNode(String boneName) {
        if (this.myHumanoidModelNode != null) {
            SkeletonControl sc = (SkeletonControl)this.myHumanoidModelNode.getControl(SkeletonControl.class);
            return sc.getAttachmentsNode(boneName);
        }
        return null;
    }

    public static void applyHumanoidJointLimits(KinematicRagdollControl krc) {
        float eighth_pi = 0.3926991f;
        krc.setJointLimit("Waist", eighth_pi, eighth_pi, eighth_pi, eighth_pi, eighth_pi, eighth_pi);
        krc.setJointLimit("Chest", eighth_pi, eighth_pi, 0.0f, 0.0f, eighth_pi, eighth_pi);
    }
}

