/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.speech.client;

import org.appdapter.core.item.Ident;
import org.cogchar.api.perform.Channel;
import org.cogchar.api.perform.Media;
import org.cogchar.api.perform.Performance;
import org.cogchar.impl.perform.FancyTextChan;
import org.cogchar.impl.perform.FancyTextPerf;
import org.cogchar.impl.perform.FancyTime;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.robokind.api.speech.SpeechService;

public class SpeechOutputClient
extends FancyTextChan {
    BundleContext myBundleCtx;

    public SpeechOutputClient(BundleContext bundleCtx, Ident chanIdent) {
        super(chanIdent);
        this.myBundleCtx = bundleCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceContext lookupSpeechServiceContext() throws Throwable {
        ServiceContext servCtx = new ServiceContext();
        servCtx.serviceRef = this.myBundleCtx.getServiceReference(SpeechService.class.getName());
        if (servCtx.serviceRef != null) {
            try {
                Object serviceObj = this.myBundleCtx.getService(servCtx.serviceRef);
                if (serviceObj != null) {
                    servCtx.speechService = (SpeechService)serviceObj;
                }
            }
            finally {
                if (servCtx.speechService == null) {
                    servCtx.release();
                    return null;
                }
            }
            return servCtx;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void speakText(String txt) {
        block7: {
            if (txt == null) {
                this.logWarning("************************* Received null speech text, ignoring");
                return;
            }
            try {
                ServiceContext servCtx = this.lookupSpeechServiceContext();
                if (servCtx != null) {
                    try {
                        this.logInfo("Trying to speakText[" + txt + "]");
                        servCtx.speechService.speak(txt);
                        break block7;
                    }
                    finally {
                        servCtx.release();
                    }
                }
                this.logWarning("************************* speech-output ServiceContext == null, ignoring speech text: " + txt);
            }
            catch (Throwable t) {
                this.logError("Problem in speakText(txt=[" + txt + "])", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllRunningSpeechTasks() {
        block6: {
            try {
                ServiceContext servCtx = this.lookupSpeechServiceContext();
                if (servCtx != null) {
                    try {
                        this.logWarning("************************* We don't have speech-cancel feature yet, sorry");
                        break block6;
                    }
                    finally {
                        servCtx.release();
                    }
                }
                this.logWarning("**************** speech-output ServiceContext == null,  ignoring request to cancelAllRunningSpeechTasks");
            }
            catch (Throwable t) {
                this.logError("Exception in cancelAllRunningSpeechTasks()", t);
            }
        }
    }

    protected void attemptMediaStartNow(Media.Text m) throws Throwable {
        String textStr = m.getFullText();
        this.speakText(textStr);
    }

    public Performance<Media.Text, FancyTime> makePerformanceForMedia(Media.Text m) {
        return new FancyTextPerf(m, (Channel.Text)this);
    }

    public class ServiceContext {
        public ServiceReference serviceRef;
        public SpeechService speechService;

        public void release() {
            if (this.serviceRef != null) {
                SpeechOutputClient.this.myBundleCtx.ungetService(this.serviceRef);
            }
        }

        public void speak() {
        }
    }
}

