/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.svc;

import java.io.File;
import java.util.Dictionary;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;
import org.robokind.api.common.osgi.lifecycle.OSGiComponent;
import org.robokind.api.common.services.ServiceConnectionDirectory;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.jointgroup.JointGroup;
import org.robokind.api.motion.jointgroup.RobotJointGroup;
import org.robokind.api.motion.lifecycle.RobotJointGroupLifecycle;
import org.robokind.impl.motion.jointgroup.RobotJointGroupConfigXMLReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RobotServiceFuncs {
    static Logger theLogger = LoggerFactory.getLogger(RobotServiceFuncs.class);

    public static JointGroup registerJointGroup(BundleContext bundleCtx, File jointGroupConfigXML_file) throws Throwable {
        JointGroup group = (JointGroup)ServiceConnectionDirectory.buildService((BundleContext)bundleCtx, (VersionProperty)RobotJointGroup.VERSION, (VersionProperty)RobotJointGroupConfigXMLReader.VERSION, (Object)jointGroupConfigXML_file, File.class, JointGroup.class);
        if (group != null) {
            bundleCtx.registerService(JointGroup.class.getName(), (Object)group, (Dictionary)new Properties());
            theLogger.warn("JointGroup Registered.");
        }
        return group;
    }

    public static void startJointGroup(BundleContext bundleCtx, Robot robot, File jointGroupConfigXML_file) {
        Robot.Id robotId = robot.getRobotId();
        RobotServiceFuncs.startJointGroup(bundleCtx, robotId, jointGroupConfigXML_file);
    }

    public static void startJointGroup(BundleContext bundleCtx, Robot.Id robotId, File jointGroupConfigXML_file) {
        String paramId = "robot/" + robotId + "/jointgroup/config/param/xml";
        RobotServiceFuncs.launchJointGroupLifecycle(bundleCtx, robotId, paramId);
        RobotServiceFuncs.launchJointGroupConfig(bundleCtx, jointGroupConfigXML_file, paramId);
    }

    protected static OSGiComponent launchJointGroupLifecycle(BundleContext bundleCtx, Robot.Id robotId, String configFileId) {
        RobotJointGroupLifecycle lifecycle = new RobotJointGroupLifecycle(robotId, File.class, configFileId, RobotJointGroupConfigXMLReader.VERSION);
        OSGiComponent jointGroupComp = new OSGiComponent(bundleCtx, (ServiceLifecycleProvider)lifecycle);
        jointGroupComp.start();
        return null;
    }

    protected static OSGiComponent launchJointGroupConfig(BundleContext context, File jointGroupConfigXML, String configFileId) {
        Properties props = new Properties();
        props.put("configParamId", configFileId);
        props.put("configFormatVersion", RobotJointGroupConfigXMLReader.VERSION.toString());
        SimpleLifecycle lifecycle = new SimpleLifecycle((Object)jointGroupConfigXML, File.class, props);
        OSGiComponent paramComp = new OSGiComponent(context, (ServiceLifecycleProvider)lifecycle);
        paramComp.start();
        return paramComp;
    }
}

