/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.svc;

import java.io.File;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.appdapter.core.log.BasicDebugger;
import org.cogchar.bind.rk.robot.svc.RobotServiceFuncs;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.utils.RobotUtils;
import org.robokind.impl.messaging.utils.ConnectionManager;
import org.robokind.impl.motion.lifecycle.RemoteRobotHostServiceGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RobotServiceContext<R extends Robot>
extends BasicDebugger {
    static Logger theLogger = LoggerFactory.getLogger(RobotServiceContext.class);
    protected BundleContext myBundleCtx;
    private R myRobot;
    private ServiceRegistration myRobotReg;

    public RobotServiceContext(BundleContext bundleCtx) {
        this.myBundleCtx = bundleCtx;
    }

    public BundleContext getBundleContext() {
        return this.myBundleCtx;
    }

    public R getRobot() {
        if (this.myRobot == null) {
            theLogger.warn("No Robot Set");
        }
        return this.myRobot;
    }

    protected void registerRobot(R robot) throws Exception {
        this.myRobot = robot;
        this.myRobot.connect();
        this.myRobotReg = RobotUtils.registerRobot((BundleContext)this.myBundleCtx, robot, null);
        if (this.myRobotReg == null) {
            throw new Exception("Error Registering Robot: " + robot);
        }
    }

    protected void launchRemoteHost(String ip) {
        if (ip == null) {
            throw new NullPointerException();
        }
        if (this.myRobot == null) {
            theLogger.warn("No Robot Set");
            return;
        }
        Connection con = ConnectionManager.createConnection((String)"admin", (String)"admin", (String)"client1", (String)"test", (String)("tcp://" + ip));
        if (con == null) {
            return;
        }
        try {
            con.start();
            new RemoteRobotHostServiceGroup(this.myBundleCtx, this.myRobot.getRobotId(), "host", "client", con, null).start();
        }
        catch (JMSException ex) {
            theLogger.warn("Could not connect to broker: " + ip, (Throwable)ex);
        }
    }

    public void registerAndStart(R robot) throws Throwable {
        this.registerRobot(robot);
        this.launchRemoteHost("127.0.0.1:5672");
    }

    public void startJointGroup(File jointGroupConfigXML_file) {
        RobotServiceFuncs.startJointGroup(this.myBundleCtx, this.myRobot, jointGroupConfigXML_file);
    }
}

