/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.svc;

import org.cogchar.bind.rk.robot.svc.RobotServiceContext;
import org.osgi.framework.BundleContext;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.blending.FrameSource;
import org.robokind.api.motion.lifecycle.DefaultBlenderServiceGroup;
import org.robokind.api.motion.utils.RobotMoverFrameSource;
import org.robokind.api.motion.utils.RobotUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlendingRobotServiceContext<R extends Robot>
extends RobotServiceContext<R> {
    static Logger theLogger = LoggerFactory.getLogger(BlendingRobotServiceContext.class);
    private DefaultBlenderServiceGroup myBlenderGroup;
    private RobotMoverFrameSource myFrameSource;

    public BlendingRobotServiceContext(BundleContext bundleCtx) {
        super(bundleCtx);
    }

    protected void startDefaultBlender() {
        Object robot = this.getRobot();
        if (robot == null) {
            return;
        }
        Robot.Id robotID = robot.getRobotId();
        theLogger.info("Starting default blender for robotID: " + robotID);
        this.myBlenderGroup = new DefaultBlenderServiceGroup(this.myBundleCtx, robotID, 40L, null);
        this.myBlenderGroup.start();
    }

    protected void registerFrameSource() {
        Object robot = this.getRobot();
        if (robot == null) {
            return;
        }
        Robot.Id robotID = robot.getRobotId();
        this.myFrameSource = new RobotMoverFrameSource(robot);
        theLogger.info("Registering FrameSource for robotID: " + robotID);
        RobotUtils.registerFrameSource((BundleContext)this.myBundleCtx, (Robot.Id)robot.getRobotId(), (FrameSource)this.myFrameSource);
    }

    protected void testPositionMove() {
        Object robot = this.getRobot();
        if (robot == null) {
            return;
        }
        Robot.RobotPositionMap positions = robot.getDefaultPositions();
        this.myFrameSource.move(positions, 1500L);
    }

    @Override
    public void registerAndStart(R robot) throws Throwable {
        super.registerAndStart(robot);
        this.startDefaultBlender();
        this.registerFrameSource();
        this.testPositionMove();
    }
}

