/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cogchar.api.skeleton.config.BoneProjectionPosition;
import org.cogchar.bind.rk.robot.model.ModelJoint;
import org.cogchar.bind.rk.robot.model.ModelRobot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRobotUtils {
    static Logger theLogger = LoggerFactory.getLogger(ModelRobotUtils.class);

    private static void appendBoneRotation(Map<String, List<BoneProjectionPosition>> rotListMap, BoneProjectionPosition rot) {
        String bone = rot.getBoneName();
        List<BoneProjectionPosition> rotList = rotListMap.get(bone);
        if (rotList == null) {
            rotList = new ArrayList<BoneProjectionPosition>();
            rotListMap.put(bone, rotList);
        }
        rotList.add(rot);
    }

    public static Map<String, List<BoneProjectionPosition>> getGoalAnglesAsRotations(ModelRobot robot) {
        HashMap<String, List<BoneProjectionPosition>> rotListMap = new HashMap<String, List<BoneProjectionPosition>>();
        ArrayList joints = new ArrayList(robot.getJointList());
        for (ModelJoint j : joints) {
            for (BoneProjectionPosition rot : j.getRotationListForCurrentGoal()) {
                ModelRobotUtils.appendBoneRotation(rotListMap, rot);
            }
        }
        return rotListMap;
    }
}

