/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.model;

import java.util.ArrayList;
import java.util.List;
import org.cogchar.api.skeleton.config.BoneJointConfig;
import org.cogchar.api.skeleton.config.BoneProjectionPosition;
import org.cogchar.api.skeleton.config.BoneProjectionRange;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.motion.AbstractJoint;
import org.robokind.api.motion.Joint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelJoint
extends AbstractJoint {
    static Logger theLogger = LoggerFactory.getLogger(ModelJoint.class);
    private boolean myEnabledFlag = false;
    private NormalizedDouble myDefaultPosNorm;
    private NormalizedDouble myGoalPosNorm;
    private String myJointName;
    private List<BoneProjectionRange> myBoneProjectionRanges;

    protected ModelJoint(Joint.Id jointId, BoneJointConfig bjc) {
        super(jointId);
        this.myJointName = bjc.myJointName;
        this.updateConfig(bjc);
        this.hardResetGoalPosToDefault();
    }

    public void updateConfig(BoneJointConfig bjc) {
        double defPosVal = Utils.bound((double)bjc.myNormalDefaultPos, (double)0.0, (double)1.0);
        this.myDefaultPosNorm = new NormalizedDouble(defPosVal);
        this.myBoneProjectionRanges = bjc.myProjectionRanges;
        this.hardResetGoalPosToDefault();
    }

    public void hardResetGoalPosToDefault() {
        this.setGoalPosition(this.getDefaultPosition());
    }

    protected String getDescription() {
        return "JOINT[" + this.getId() + ", " + this.myJointName + "]";
    }

    public String toString() {
        return this.getDescription() + "-[enabled=" + this.myEnabledFlag + ", goalPos=" + this.myGoalPosNorm + "]";
    }

    public void setEnabled(Boolean enabled) {
        theLogger.info(this.getDescription() + ".setEnabled(" + enabled + ")");
        this.myEnabledFlag = enabled;
    }

    public Boolean getEnabled() {
        return this.myEnabledFlag;
    }

    public String getName() {
        return this.myJointName;
    }

    public NormalizedDouble getDefaultPosition() {
        return this.myDefaultPosNorm;
    }

    public NormalizedDouble getGoalPosition() {
        return this.myGoalPosNorm;
    }

    public List<BoneProjectionRange> getBoneRotationRanges() {
        return this.myBoneProjectionRanges;
    }

    void setGoalPosition(NormalizedDouble pos) {
        theLogger.trace(this.getDescription() + ".setGoalPosition(" + pos + ")");
        NormalizedDouble old = this.getGoalPosition();
        this.firePropertyChange("goalPosition", old, pos);
        this.myGoalPosNorm = pos;
    }

    public List<BoneProjectionPosition> getRotationListForNormPos(NormalizedDouble normPos) {
        ArrayList<BoneProjectionPosition> rotations = new ArrayList<BoneProjectionPosition>(this.myBoneProjectionRanges.size());
        for (BoneProjectionRange range : this.myBoneProjectionRanges) {
            rotations.add(range.makePositionForNormalizedFraction(normPos.getValue()));
        }
        return rotations;
    }

    public List<BoneProjectionPosition> getRotationListForCurrentGoal() {
        NormalizedDouble normGoalPos = this.getGoalPosition();
        return this.getRotationListForNormPos(normGoalPos);
    }
}

