/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.client;

import java.util.ArrayList;
import java.util.List;
import org.appdapter.core.item.Ident;
import org.appdapter.core.log.BasicDebugger;
import org.cogchar.api.perform.Channel;
import org.cogchar.api.perform.Media;
import org.cogchar.api.perform.Performance;
import org.cogchar.bind.rk.robot.client.RobotAnimClient;
import org.cogchar.bind.rk.robot.svc.RobotServiceContext;
import org.cogchar.blob.emit.BehaviorConfigEmitter;
import org.cogchar.impl.perform.ChannelNames;
import org.cogchar.impl.perform.FancyTextChan;
import org.cogchar.impl.perform.FancyTextPerf;
import org.cogchar.impl.perform.FancyTime;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.player.AnimationJob;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.utils.RobotUtils;

public class RobotAnimContext
extends BasicDebugger {
    private Ident myCharIdent;
    private Robot myTargetRobot;
    private RobotAnimClient myAnimClient;
    private List<AnimationJob> myJobsInStartOrder = new ArrayList<AnimationJob>();
    private Animation myDangerYogaAnim;
    private TriggeringChannel myTriggeringChannel;
    private BehaviorConfigEmitter myBehaviorCE;

    public RobotAnimContext(Ident charIdent, BehaviorConfigEmitter behavCE) {
        this.myCharIdent = charIdent;
        this.myBehaviorCE = behavCE;
    }

    public void initConn(RobotServiceContext robotSvcContext) {
        try {
            BundleContext osgiBundleCtx = robotSvcContext.getBundleContext();
            this.myTargetRobot = robotSvcContext.getRobot();
            Robot.Id robotId = this.myTargetRobot.getRobotId();
            this.logInfo("***************************** Using robotId: " + robotId);
            String osgiFilterStringForAnimPlayer = RobotUtils.getRobotFilter((Robot.Id)robotId);
            this.logInfo("***************************** Using osgiFilterStringForAnimPlayer: " + osgiFilterStringForAnimPlayer);
            this.myAnimClient = new RobotAnimClient(osgiBundleCtx, osgiFilterStringForAnimPlayer);
        }
        catch (Throwable t) {
            this.logError("Cannot init RobotAnimClient for char[" + this.myCharIdent + "]", t);
        }
    }

    public void stopAndReset() {
        this.endAndClearKnownAnimationJobs();
    }

    public void endAndClearKnownAnimationJobs() {
        ArrayList<AnimationJob> notCleared = new ArrayList<AnimationJob>();
        int clearedCount = 0;
        int unclearedCount = 0;
        for (AnimationJob aj : this.myJobsInStartOrder) {
            if (this.myAnimClient.endAndClearAnimationJob(aj)) {
                this.logInfo("endAndClear success #" + ++clearedCount + " on AnimationJob " + aj);
                continue;
            }
            notCleared.add(aj);
            this.logWarning("****** endAndClear FAILURE #" + ++unclearedCount + " on AnimationJob " + aj);
        }
        this.myJobsInStartOrder = notCleared;
        this.logInfo("endAndClear complete, succeededCount=" + clearedCount + ", failedCount=" + unclearedCount);
    }

    public synchronized void startFullAnimationNow(Animation anim) {
        AnimationJob aj = this.myAnimClient.playFullAnimationNow(anim);
        if (aj != null) {
            this.myJobsInStartOrder.add(aj);
            this.logInfo("Started AnimationJob: [" + aj + "]");
        } else {
            this.logWarning("********************* Could not start animation[" + anim + "]");
        }
    }

    public void playDangerYogaTestAnimNow() {
        if (this.myAnimClient != null) {
            if (this.myDangerYogaAnim == null) {
                try {
                    this.myDangerYogaAnim = this.myAnimClient.makeDangerYogaAnim();
                }
                catch (Throwable t) {
                    this.logError("Problem creating DangerYoga TestAnim", t);
                    return;
                }
            }
            this.startFullAnimationNow(this.myDangerYogaAnim);
        } else {
            this.logWarning("******************** Cannot play DangerYoga test anim because myAnimClient == null");
        }
    }

    public TriggeringChannel getTriggeringChannel() {
        if (this.myTriggeringChannel == null) {
            Ident id = ChannelNames.getOutChanIdent_AnimBest();
            this.logInfo("Creating triggering channel with ident=" + id);
            this.myTriggeringChannel = new TriggeringChannel(id);
        }
        return this.myTriggeringChannel;
    }

    public class TriggeringChannel
    extends FancyTextChan {
        private boolean myUseTempAnimsFlag;

        public TriggeringChannel(Ident id) {
            super(id);
            this.myUseTempAnimsFlag = false;
        }

        public void setUseTempAnims(boolean flag) {
            this.myUseTempAnimsFlag = flag;
        }

        protected void attemptMediaStartNow(Media.Text m) throws Throwable {
            String animPathStr = m.getFullText();
            String fullPath = null;
            fullPath = RobotAnimContext.this.myBehaviorCE.getRKAnimationTempFilePath(animPathStr);
            this.logInfo("Attempting to start animation at relative path[" + fullPath + "]");
            Animation anim = RobotAnimContext.this.myAnimClient.readAnimationFromFile(fullPath);
            if (anim != null) {
                RobotAnimContext.this.startFullAnimationNow(anim);
            }
        }

        public Performance<Media.Text, FancyTime> makePerformanceForMedia(Media.Text m) {
            return new FancyTextPerf(m, (Channel.Text)this);
        }
    }

    static enum AnimChannel {
        RK_XML_BEST,
        RK_XML_PERM,
        RK_XML_TEMP;

    }
}

