/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.client;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.appdapter.core.log.BasicDebugger;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.Channel;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.animation.player.AnimationJob;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.animation.utils.AnimationUtils;
import org.robokind.api.animation.utils.ChannelsParameterSource;
import org.robokind.api.common.playable.PlayState;
import org.robokind.impl.animation.xml.AnimationXMLReader;

public class RobotAnimClient
extends BasicDebugger {
    private BundleContext myBundleCtx;
    private String myAnimPlayerOsgiFilterString;
    private AnimationXMLReader myAnimationReader;

    public RobotAnimClient(BundleContext bundleCtx, String animationPlayerOsgiFilterString) throws Exception {
        this.myBundleCtx = bundleCtx;
        this.myAnimPlayerOsgiFilterString = animationPlayerOsgiFilterString;
    }

    public AnimationXMLReader getAnimationReader() {
        if (this.myAnimationReader == null) {
            this.myAnimationReader = new AnimationXMLReader();
        }
        return this.myAnimationReader;
    }

    public AnimationJob playAnimationSegmentNow(Animation anim, long segBeginOffsetMsec, long segEndOffsetMsec) {
        return AnimationUtils.playAnimation((BundleContext)this.myBundleCtx, (String)this.myAnimPlayerOsgiFilterString, (Animation)anim, (long)segBeginOffsetMsec, (long)segEndOffsetMsec);
    }

    public AnimationJob playFullAnimationNow(Animation anim) {
        return AnimationUtils.playAnimation((BundleContext)this.myBundleCtx, (String)this.myAnimPlayerOsgiFilterString, (Animation)anim);
    }

    public boolean markAnimationJobComplete(AnimationJob aj) {
        PlayState curPlayState = aj.getPlayState();
        if (curPlayState == PlayState.COMPLETED) {
            return true;
        }
        long nowMsec = System.currentTimeMillis();
        return aj.complete(nowMsec);
    }

    public boolean endAndClearAnimationJob(AnimationJob aj) {
        boolean markedOK = this.markAnimationJobComplete(aj);
        if (markedOK) {
            AnimationPlayer player = aj.getSource();
            player.removeAnimationJob(aj);
            return true;
        }
        this.logWarning("Could not 'COMPLETE' animationJob, so not removing it: [" + aj + "]");
        return false;
    }

    public List<AnimationJob> getAllCurrentAnimationsForPlayer(AnimationPlayer ap) {
        return ap.getCurrentAnimations();
    }

    public Animation readAnimationFromFile(String filepath) {
        try {
            return new AnimationXMLReader().readAnimation(filepath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Animation readAnimation(HierarchicalConfiguration config) {
        AnimationXMLReader axr = this.getAnimationReader();
        return AnimationXMLReader.readAnimation((HierarchicalConfiguration)config);
    }

    public HierarchicalConfiguration readXmlConfigFile(String xmlConfFilePath) {
        XMLConfiguration config = null;
        try {
            config = new XMLConfiguration(xmlConfFilePath);
        }
        catch (ConfigurationException t) {
            this.logWarning("Cannont open Robokind animation XML  file [" + xmlConfFilePath + "]", t);
        }
        catch (Exception t) {
            this.logError("Error reading Robokind animation XML  file  [" + xmlConfFilePath + "]", t);
        }
        return config;
    }

    public HierarchicalConfiguration readXmlConfigUrl(String xmlConfUrl) {
        XMLConfiguration config = null;
        try {
            URL url = new URL(xmlConfUrl);
            config = new XMLConfiguration(url);
        }
        catch (ConfigurationException t) {
            this.logWarning("Cannont open Robokind animation XML URL [" + xmlConfUrl + "]", t);
        }
        catch (Exception t) {
            this.logError("Error reading Robokind animation XML URL [" + xmlConfUrl + "]", t);
        }
        return config;
    }

    public Animation makeDangerYogaAnim() throws Exception {
        ChannelsParameterSource cpSource = AnimationUtils.getChannelsParameterSource();
        this.logInfo(-10, "channelParamSource=" + cpSource);
        Map chanNames = cpSource.getChannelNames();
        this.logInfo("Test animation channelNames=" + chanNames);
        Animation anim = new Animation();
        for (Map.Entry e : chanNames.entrySet()) {
            Channel chan = new Channel(((Integer)e.getKey()).intValue(), (String)e.getValue());
            MotionPath path = new MotionPath();
            path.addPoint(0.0, 0.5);
            path.addPoint(1000.0, 1.0);
            path.addPoint(3000.0, 0.0);
            path.addPoint(4000.0, 0.5);
            chan.addPath(path);
            anim.addChannel(chan);
        }
        return anim;
    }
}

