/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.gaze;

import java.awt.Rectangle;
import java.util.List;
import org.cogchar.animoid.gaze.IGazeTarget;
import org.cogchar.api.animoid.protocol.EgocentricDirection;
import org.cogchar.api.sight.SightObservation;
import org.cogchar.bind.rk.gaze.GazeTargetMotionPlanner;
import org.cogchar.bind.rk.gaze.GazeTracker;
import org.cogchar.bind.rk.gaze.ImageEgocentricConverter;
import org.cogchar.bind.rk.gaze.ImageJointSnapshotCoordinate;
import org.osgi.framework.BundleContext;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.blending.FrameSource;
import org.robokind.api.motion.protocol.DefaultMotionFrame;
import org.robokind.api.motion.protocol.JointPositionMap;
import org.robokind.api.motion.protocol.MotionFrame;
import org.robokind.api.motion.utils.RobotUtils;
import org.robokind.api.vision.ImageRegion;

public class ImageTrackerFrameSource
implements FrameSource<Robot.RobotPositionMap> {
    private ImageEgocentricConverter myCoordinateConverter;
    private GazeTracker myTracker;
    private GazeTargetMotionPlanner myPlanner;
    private BundleContext myContext;
    private Robot.Id myRobotId;

    public void trackRegion(ImageRegion region, long time) {
        ImageJointSnapshotCoordinate ijsc = this.convertImageRegionToIJSC(region);
        if (ijsc == null) {
            return;
        }
        SightObservation obs = this.convertIJSCtoObservation(ijsc);
        if (obs == null) {
            return;
        }
        obs.setTimeStampMsec(time);
        this.myTracker.addObservation(obs);
    }

    private ImageJointSnapshotCoordinate convertImageRegionToIJSC(ImageRegion reg) {
        Robot.RobotPositionMap pos = RobotUtils.getCurrentPositions((BundleContext)this.myContext, (Robot.Id)this.myRobotId);
        if (pos == null) {
            return null;
        }
        int width = 320;
        int height = 240;
        return new ImageJointSnapshotCoordinate(width, height, reg, pos);
    }

    private SightObservation convertIJSCtoObservation(ImageJointSnapshotCoordinate ijsc) {
        EgocentricDirection edir = this.myCoordinateConverter.convert(ijsc);
        SightObservation obs = new SightObservation();
        obs.setCenterDirection(edir);
        ImageRegion region = ijsc.getImageRegion();
        int x = region.getX();
        int y = region.getY();
        int w = region.getWidth();
        int h = region.getHeight();
        Rectangle rect = new Rectangle(x, y, w, h);
        obs.setBoundRect(rect);
        return obs;
    }

    public MotionFrame getMovements(long time, long interval) {
        List<IGazeTarget> targets = this.myTracker.getObservationTrackers();
        if (targets == null || targets.isEmpty()) {
            return null;
        }
        IGazeTarget target = targets.get(0);
        Robot.RobotPositionMap curPos = RobotUtils.getCurrentPositions((BundleContext)this.myContext, (Robot.Id)this.myRobotId);
        Robot.RobotPositionMap goals = this.myPlanner.getMovements(time, interval, target, curPos);
        DefaultMotionFrame frame = new DefaultMotionFrame();
        frame.setFrameLengthMillisec(interval);
        frame.setTimestampMillisecUTC(time);
        frame.setPreviousPositions((JointPositionMap)curPos);
        frame.setGoalPositions((JointPositionMap)goals);
        return frame;
    }
}

