/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.speech.client;

import org.cogchar.bind.rk.robot.client.RobotAnimClient;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.robokind.api.speech.SpeechService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechOutputClient {
    static Logger theLogger = LoggerFactory.getLogger(RobotAnimClient.class);
    BundleContext myBundleCtx;

    public SpeechOutputClient(BundleContext bundleCtx) {
        this.myBundleCtx = bundleCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceContext lookupSpeechService() throws Throwable {
        ServiceContext servCtx = new ServiceContext();
        servCtx.serviceRef = this.myBundleCtx.getServiceReference(SpeechService.class.getName());
        if (servCtx.serviceRef != null) {
            try {
                Object serviceObj = this.myBundleCtx.getService(servCtx.serviceRef);
                if (serviceObj != null) {
                    servCtx.speechService = (SpeechService)serviceObj;
                }
            }
            finally {
                if (servCtx.speechService == null) {
                    servCtx.release();
                    return null;
                }
            }
            return servCtx;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void speakText(String txt) throws Throwable {
        theLogger.info("Trying to speakText: " + txt);
        if (txt == null) {
            throw new Exception("Speech text is null");
        }
        ServiceContext servCtx = this.lookupSpeechService();
        if (servCtx != null) {
            try {
                if (servCtx != null) {
                    servCtx.speechService.speak(txt);
                }
            }
            finally {
                servCtx.release();
            }
        }
    }

    public class ServiceContext {
        public ServiceReference serviceRef;
        public SpeechService speechService;

        public void release() {
            if (this.serviceRef != null) {
                SpeechOutputClient.this.myBundleCtx.ungetService(this.serviceRef);
            }
        }

        public void speak() {
        }
    }
}

