/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.svc;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Dictionary;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.qpid.client.AMQQueue;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.services.ServiceConnectionDirectory;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.jointgroup.JointGroup;
import org.robokind.api.motion.jointgroup.RobotJointGroup;
import org.robokind.impl.messaging.utils.ConnectionManager;
import org.robokind.impl.motion.jointgroup.RobotJointGroupConfigXMLReader;
import org.robokind.impl.motion.messaging.JMSMotionFrameAsyncReceiver;
import org.robokind.impl.motion.messaging.TargetFrameListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RobotServiceFuncs {
    static Logger theLogger = LoggerFactory.getLogger(RobotServiceFuncs.class);

    public static JMSMotionFrameAsyncReceiver createAndRegisterFrameReceiver(BundleContext bundleCtx, Robot.Id robotId) {
        AMQQueue destination;
        Session session;
        Connection connection = ConnectionManager.createConnection((String)"admin", (String)"admin", (String)"client1", (String)"test", (String)"tcp://127.0.0.1:5672");
        JMSMotionFrameAsyncReceiver receiver = null;
        try {
            connection.start();
        }
        catch (JMSException ex) {
            theLogger.warn("Could not start connection.", (Throwable)ex);
            return null;
        }
        if (connection == null) {
            return null;
        }
        String queue = "test.RobotMoveQueue; {create: always, node: {type: queue}}";
        try {
            session = connection.createSession(false, 2);
            destination = new AMQQueue(queue);
        }
        catch (URISyntaxException ex) {
            theLogger.warn("Error creating destination.", (Throwable)ex);
            return null;
        }
        catch (JMSException ex) {
            theLogger.warn("Error creating session.", (Throwable)ex);
            return null;
        }
        try {
            receiver = RobotServiceFuncs.startRobotFrameReceiver(bundleCtx, robotId, session, (Destination)destination);
        }
        catch (Throwable t) {
            theLogger.warn("Error starting Robot Server.", t);
        }
        return receiver;
    }

    private static JMSMotionFrameAsyncReceiver startRobotFrameReceiver(BundleContext context, Robot.Id id, Session session, Destination destination) throws Throwable {
        JMSMotionFrameAsyncReceiver receiver = new JMSMotionFrameAsyncReceiver(session, destination);
        TargetFrameListener moveHandler = new TargetFrameListener();
        receiver.addMessageListener((Listener)moveHandler);
        receiver.start();
        return receiver;
    }

    public static JointGroup registerJointGroup(BundleContext bundleCtx, File jointGroupConfigXML_file) throws Throwable {
        JointGroup group = (JointGroup)ServiceConnectionDirectory.buildService((BundleContext)bundleCtx, (VersionProperty)RobotJointGroup.VERSION, (VersionProperty)RobotJointGroupConfigXMLReader.VERSION, (Object)jointGroupConfigXML_file, File.class, JointGroup.class);
        if (group != null) {
            bundleCtx.registerService(JointGroup.class.getName(), (Object)group, (Dictionary)new Properties());
            theLogger.warn("JointGroup Registered.");
        }
        return group;
    }
}

