/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.svc;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.utils.RobotUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RobotServiceContext<R extends Robot> {
    static Logger theLogger = LoggerFactory.getLogger(RobotServiceContext.class);
    protected BundleContext myBundleCtx;
    private R myRobot;
    private ServiceRegistration myRobotReg;

    public RobotServiceContext(BundleContext bundleCtx) {
        this.myBundleCtx = bundleCtx;
    }

    public BundleContext getBundleContext() {
        return this.myBundleCtx;
    }

    public R getRobot() {
        return this.myRobot;
    }

    protected void registerRobot(R robot) throws Exception {
        this.myRobot = robot;
        this.myRobot.connect();
        this.myRobotReg = RobotUtils.registerRobot((BundleContext)this.myBundleCtx, robot, null);
        if (this.myRobotReg == null) {
            throw new Exception("Error Registering Robot: " + robot);
        }
    }

    public void registerAndStart(R robot) throws Throwable {
        this.registerRobot(robot);
    }
}

