/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.svc;

import java.io.File;
import org.cogchar.bind.rk.robot.model.ModelRobot;
import org.cogchar.bind.rk.robot.model.ModelRobotFactory;
import org.cogchar.bind.rk.robot.svc.BlendingRobotServiceContext;
import org.osgi.framework.BundleContext;
import org.robokind.api.motion.Robot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelBlendingRobotServiceContext
extends BlendingRobotServiceContext<ModelRobot> {
    static Logger theLogger = LoggerFactory.getLogger(ModelBlendingRobotServiceContext.class);

    public ModelBlendingRobotServiceContext(BundleContext bundleCtx) {
        super(bundleCtx);
    }

    public void makeModelRobotWithBlenderAndFrameSource(File jointBindingConfigFile) throws Throwable {
        String bindingFilePath = jointBindingConfigFile.getAbsolutePath();
        theLogger.info("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& START makeBonyRobot__, using file: " + bindingFilePath);
        ModelRobot br = ModelRobotFactory.buildFromFile(jointBindingConfigFile);
        if (br == null) {
            theLogger.warn("Error building Robot from file: " + bindingFilePath);
            return;
        }
        this.registerAndStart(br);
        theLogger.info("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& END makeBonyRobotWithBlenderAndFrameSource ");
    }

    public void registerDummyModelRobot() throws Throwable {
        theLogger.info("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& START registerDummyBlendingRobot");
        Robot.Id hbID = new Robot.Id("temp");
        ModelRobot br = new ModelRobot(hbID);
        this.registerAndStart(br);
        theLogger.info("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& END registerDummyBlendingRobot");
    }
}

