/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.bind.rk.robot.svc;

import org.cogchar.bind.rk.robot.svc.RobotServiceContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.protocol.FrameSource;
import org.robokind.api.motion.utils.RobotMoverFrameSource;
import org.robokind.api.motion.utils.RobotUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlendingRobotServiceContext<R extends Robot>
extends RobotServiceContext<R> {
    static Logger theLogger = LoggerFactory.getLogger(BlendingRobotServiceContext.class);
    private ServiceRegistration[] myBlenderRegs;
    private RobotMoverFrameSource myFrameSource;

    public BlendingRobotServiceContext(BundleContext bundleCtx) {
        super(bundleCtx);
    }

    protected void startDefaultBlender() {
        Object robot = this.getRobot();
        this.myBlenderRegs = RobotUtils.startDefaultBlender((BundleContext)this.myBundleCtx, (Robot.Id)robot.getRobotId(), (long)40L);
    }

    protected void registerFrameSource() {
        Object robot = this.getRobot();
        this.myFrameSource = new RobotMoverFrameSource(robot);
        RobotUtils.registerFrameSource((BundleContext)this.myBundleCtx, (Robot.Id)robot.getRobotId(), (FrameSource)this.myFrameSource);
    }

    protected void testPositionMove() {
        Robot.RobotPositionHashMap positions = new Robot.RobotPositionHashMap();
        this.myFrameSource.move((Robot.RobotPositionMap)positions, 1500L);
    }

    @Override
    public void registerAndStart(R robot) throws Throwable {
        super.registerAndStart(robot);
        this.startDefaultBlender();
        this.registerFrameSource();
        this.testPositionMove();
    }
}

